package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LineageTree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLineageTree.builder()}.
 */
@Generated(from = "LineageTree", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableLineageTree implements LineageTree {
  private final String name;
  private final String database;
  private final boolean privateNode;
  private final LineageTreeType type;
  private final List<LineageTree> children;

  private ImmutableLineageTree(ImmutableLineageTree.Builder builder) {
    this.name = builder.name;
    this.database = builder.database;
    if (builder.privateNodeIsSet()) {
      initShim.privateNode(builder.privateNode);
    }
    if (builder.type != null) {
      initShim.type(builder.type);
    }
    if (builder.childrenIsSet()) {
      initShim.children(List.copyOf(builder.children));
    }
    this.privateNode = initShim.privateNode();
    this.type = initShim.type();
    this.children = initShim.children();
    this.initShim = null;
  }

  private ImmutableLineageTree(
      String name,
      String database,
      boolean privateNode,
      LineageTreeType type,
      List<LineageTree> children) {
    this.name = name;
    this.database = database;
    this.privateNode = privateNode;
    this.type = type;
    this.children = children;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "LineageTree", generator = "Immutables")
  private final class InitShim {
    private byte privateNodeBuildStage = STAGE_UNINITIALIZED;
    private boolean privateNode;

    boolean privateNode() {
      if (privateNodeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (privateNodeBuildStage == STAGE_UNINITIALIZED) {
        privateNodeBuildStage = STAGE_INITIALIZING;
        this.privateNode = privateNodeInitialize();
        privateNodeBuildStage = STAGE_INITIALIZED;
      }
      return this.privateNode;
    }

    void privateNode(boolean privateNode) {
      this.privateNode = privateNode;
      privateNodeBuildStage = STAGE_INITIALIZED;
    }

    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private LineageTreeType type;

    LineageTreeType type() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(typeInitialize(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void type(LineageTreeType type) {
      this.type = type;
      typeBuildStage = STAGE_INITIALIZED;
    }

    private byte childrenBuildStage = STAGE_UNINITIALIZED;
    private List<LineageTree> children;

    List<LineageTree> children() {
      if (childrenBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (childrenBuildStage == STAGE_UNINITIALIZED) {
        childrenBuildStage = STAGE_INITIALIZING;
        this.children = childrenInitialize() instanceof Collection<?>
       ? List.copyOf((Collection<? extends LineageTree>) childrenInitialize())
       : StreamSupport.stream(childrenInitialize().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
        childrenBuildStage = STAGE_INITIALIZED;
      }
      return this.children;
    }

    void children(List<LineageTree> children) {
      this.children = children;
      childrenBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (privateNodeBuildStage == STAGE_INITIALIZING) attributes.add("privateNode");
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      if (childrenBuildStage == STAGE_INITIALIZING) attributes.add("children");
      return "Cannot build LineageTree, attribute initializers form cycle " + attributes;
    }
  }

  private boolean privateNodeInitialize() {
    return LineageTree.super.privateNode();
  }

  private LineageTreeType typeInitialize() {
    return LineageTree.super.type();
  }

  private List<LineageTree> childrenInitialize() {
    return LineageTree.super.children();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @JsonProperty("database")
  @Override
  public String database() {
    return database;
  }

  /**
   * @return The value of the {@code privateNode} attribute
   */
  @JsonProperty("privateNode")
  @Override
  public boolean privateNode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.privateNode()
        : this.privateNode;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public LineageTreeType type() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.type()
        : this.type;
  }

  /**
   * @return The value of the {@code children} attribute
   */
  @JsonProperty("children")
  @Override
  public List<LineageTree> children() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.children()
        : this.children;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LineageTree#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLineageTree withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableLineageTree(newValue, this.database, this.privateNode, this.type, this.children);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LineageTree#database() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLineageTree withDatabase(String value) {
    String newValue = Objects.requireNonNull(value, "database");
    if (this.database.equals(newValue)) return this;
    return new ImmutableLineageTree(this.name, newValue, this.privateNode, this.type, this.children);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LineageTree#privateNode() privateNode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privateNode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLineageTree withPrivateNode(boolean value) {
    if (this.privateNode == value) return this;
    return new ImmutableLineageTree(this.name, this.database, value, this.type, this.children);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LineageTree#type() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLineageTree withType(LineageTreeType value) {
    LineageTreeType newValue = Objects.requireNonNull(value, "type");
    if (this.type == newValue) return this;
    return new ImmutableLineageTree(this.name, this.database, this.privateNode, newValue, this.children);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LineageTree#children() children}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLineageTree withChildren(LineageTree... elements) {
    List<LineageTree> newValue = List.of(elements);
    return new ImmutableLineageTree(this.name, this.database, this.privateNode, this.type, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LineageTree#children() children}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of children elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLineageTree withChildren(Iterable<? extends LineageTree> elements) {
    if (this.children == elements) return this;
    List<LineageTree> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends LineageTree>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableLineageTree(this.name, this.database, this.privateNode, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLineageTree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLineageTree
        && equalTo(0, (ImmutableLineageTree) another);
  }

  private boolean equalTo(int synthetic, ImmutableLineageTree another) {
    return name.equals(another.name)
        && database.equals(another.database)
        && privateNode == another.privateNode
        && type.equals(another.type)
        && children.equals(another.children);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code database}, {@code privateNode}, {@code type}, {@code children}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + database.hashCode();
    h += (h << 5) + Boolean.hashCode(privateNode);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + children.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LineageTree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LineageTree{"
        + "name=" + name
        + ", database=" + database
        + ", privateNode=" + privateNode
        + ", type=" + type
        + ", children=" + children
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LineageTree", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LineageTree {
    @Nullable String name;
    @Nullable String database;
    boolean privateNode;
    boolean privateNodeIsSet;
    @Nullable LineageTreeType type;
    @Nullable List<LineageTree> children = List.of();
    boolean childrenIsSet;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("database")
    public void setDatabase(String database) {
      this.database = database;
    }
    @JsonProperty("privateNode")
    public void setPrivateNode(boolean privateNode) {
      this.privateNode = privateNode;
      this.privateNodeIsSet = true;
    }
    @JsonProperty("type")
    public void setType(LineageTreeType type) {
      this.type = type;
    }
    @JsonProperty("children")
    public void setChildren(List<LineageTree> children) {
      this.children = children;
      this.childrenIsSet = null != children;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String database() { throw new UnsupportedOperationException(); }
    @Override
    public boolean privateNode() { throw new UnsupportedOperationException(); }
    @Override
    public LineageTreeType type() { throw new UnsupportedOperationException(); }
    @Override
    public List<LineageTree> children() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLineageTree fromJson(Json json) {
    ImmutableLineageTree.Builder builder = ImmutableLineageTree.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.database != null) {
      builder.database(json.database);
    }
    if (json.privateNodeIsSet) {
      builder.privateNode(json.privateNode);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.childrenIsSet) {
      builder.addAllChildren(json.children);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LineageTree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LineageTree instance
   */
  public static ImmutableLineageTree copyOf(LineageTree instance) {
    if (instance instanceof ImmutableLineageTree) {
      return (ImmutableLineageTree) instance;
    }
    return ImmutableLineageTree.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLineageTree ImmutableLineageTree}.
   * <pre>
   * ImmutableLineageTree.builder()
   *    .name(String) // required {@link LineageTree#name() name}
   *    .database(String) // required {@link LineageTree#database() database}
   *    .privateNode(boolean) // optional {@link LineageTree#privateNode() privateNode}
   *    .type(zeenea.connector.denodo.client.rest.LineageTreeType) // optional {@link LineageTree#type() type}
   *    .addChildren|addAllChildren(zeenea.connector.denodo.client.rest.LineageTree) // {@link LineageTree#children() children} elements
   *    .build();
   * </pre>
   * @return A new ImmutableLineageTree builder
   */
  public static ImmutableLineageTree.Builder builder() {
    return new ImmutableLineageTree.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLineageTree ImmutableLineageTree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LineageTree", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DATABASE = 0x2L;
    private static final long OPT_BIT_PRIVATE_NODE = 0x1L;
    private static final long OPT_BIT_CHILDREN = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String name;
    private @Nullable String database;
    private boolean privateNode;
    private @Nullable LineageTreeType type;
    private List<LineageTree> children = new ArrayList<LineageTree>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LineageTree} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LineageTree instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      this.database(instance.database());
      this.privateNode(instance.privateNode());
      this.type(instance.type());
      addAllChildren(instance.children());
      return this;
    }

    /**
     * Initializes the value for the {@link LineageTree#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link LineageTree#database() database} attribute.
     * @param database The value for database 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("database")
    public final Builder database(String database) {
      this.database = Objects.requireNonNull(database, "database");
      initBits &= ~INIT_BIT_DATABASE;
      return this;
    }

    /**
     * Initializes the value for the {@link LineageTree#privateNode() privateNode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LineageTree#privateNode() privateNode}.</em>
     * @param privateNode The value for privateNode 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("privateNode")
    public final Builder privateNode(boolean privateNode) {
      this.privateNode = privateNode;
      optBits |= OPT_BIT_PRIVATE_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link LineageTree#type() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LineageTree#type() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(LineageTreeType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Adds one element to {@link LineageTree#children() children} list.
     * @param element A children element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChildren(LineageTree element) {
      this.children.add(Objects.requireNonNull(element, "children element"));
      optBits |= OPT_BIT_CHILDREN;
      return this;
    }

    /**
     * Adds elements to {@link LineageTree#children() children} list.
     * @param elements An array of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChildren(LineageTree... elements) {
      for (LineageTree element : elements) {
        this.children.add(Objects.requireNonNull(element, "children element"));
      }
      optBits |= OPT_BIT_CHILDREN;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LineageTree#children() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("children")
    public final Builder children(Iterable<? extends LineageTree> elements) {
      this.children.clear();
      return addAllChildren(elements);
    }

    /**
     * Adds elements to {@link LineageTree#children() children} list.
     * @param elements An iterable of children elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChildren(Iterable<? extends LineageTree> elements) {
      for (LineageTree element : elements) {
        this.children.add(Objects.requireNonNull(element, "children element"));
      }
      optBits |= OPT_BIT_CHILDREN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLineageTree ImmutableLineageTree}.
     * @return An immutable instance of LineageTree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLineageTree build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLineageTree(this);
    }

    private boolean privateNodeIsSet() {
      return (optBits & OPT_BIT_PRIVATE_NODE) != 0;
    }

    private boolean childrenIsSet() {
      return (optBits & OPT_BIT_CHILDREN) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DATABASE) != 0) attributes.add("database");
      return "Cannot build LineageTree, some of required attributes are not set " + attributes;
    }
  }
}
