package zeenea.connector.denodo.client.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CountRecord}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCountRecord.builder()}.
 */
@Generated(from = "CountRecord", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCountRecord implements CountRecord {
  private final String field;
  private final String expression;

  private ImmutableCountRecord(String field, String expression) {
    this.field = field;
    this.expression = expression;
  }

  /**
   * @return The value of the {@code field} attribute
   */
  @JsonProperty("field")
  @Override
  public String field() {
    return field;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("expression")
  @Override
  public String expression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CountRecord#field() field} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for field
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCountRecord withField(String value) {
    String newValue = Objects.requireNonNull(value, "field");
    if (this.field.equals(newValue)) return this;
    return new ImmutableCountRecord(newValue, this.expression);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CountRecord#expression() expression} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCountRecord withExpression(String value) {
    String newValue = Objects.requireNonNull(value, "expression");
    if (this.expression.equals(newValue)) return this;
    return new ImmutableCountRecord(this.field, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCountRecord} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCountRecord
        && equalTo(0, (ImmutableCountRecord) another);
  }

  private boolean equalTo(int synthetic, ImmutableCountRecord another) {
    return field.equals(another.field)
        && expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code field}, {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + field.hashCode();
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CountRecord} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CountRecord{"
        + "field=" + field
        + ", expression=" + expression
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CountRecord", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CountRecord {
    @Nullable String field;
    @Nullable String expression;
    @JsonProperty("field")
    public void setField(String field) {
      this.field = field;
    }
    @JsonProperty("expression")
    public void setExpression(String expression) {
      this.expression = expression;
    }
    @Override
    public String field() { throw new UnsupportedOperationException(); }
    @Override
    public String expression() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCountRecord fromJson(Json json) {
    ImmutableCountRecord.Builder builder = ImmutableCountRecord.builder();
    if (json.field != null) {
      builder.field(json.field);
    }
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CountRecord} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CountRecord instance
   */
  public static ImmutableCountRecord copyOf(CountRecord instance) {
    if (instance instanceof ImmutableCountRecord) {
      return (ImmutableCountRecord) instance;
    }
    return ImmutableCountRecord.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCountRecord ImmutableCountRecord}.
   * <pre>
   * ImmutableCountRecord.builder()
   *    .field(String) // required {@link CountRecord#field() field}
   *    .expression(String) // required {@link CountRecord#expression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableCountRecord builder
   */
  public static ImmutableCountRecord.Builder builder() {
    return new ImmutableCountRecord.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCountRecord ImmutableCountRecord}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CountRecord", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FIELD = 0x1L;
    private static final long INIT_BIT_EXPRESSION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String field;
    private @Nullable String expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.denodo.client.rest.SearchField} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchField instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.denodo.client.rest.CountRecord} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CountRecord instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof SearchField) {
        SearchField instance = (SearchField) object;
        if ((bits & 0x1L) == 0) {
          this.field(instance.field());
          bits |= 0x1L;
        }
      }
      if (object instanceof CountRecord) {
        CountRecord instance = (CountRecord) object;
        if ((bits & 0x1L) == 0) {
          this.field(instance.field());
          bits |= 0x1L;
        }
        this.expression(instance.expression());
      }
    }

    /**
     * Initializes the value for the {@link CountRecord#field() field} attribute.
     * @param field The value for field 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder field(String field) {
      this.field = Objects.requireNonNull(field, "field");
      initBits &= ~INIT_BIT_FIELD;
      return this;
    }

    /**
     * Initializes the value for the {@link CountRecord#expression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder expression(String expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCountRecord ImmutableCountRecord}.
     * @return An immutable instance of CountRecord
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCountRecord build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCountRecord(field, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIELD) != 0) attributes.add("field");
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build CountRecord, some of required attributes are not set " + attributes;
    }
  }
}
