package zeenea.connector.denodo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ViewRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableViewRef.builder()}.
 */
@Generated(from = "ViewRef", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableViewRef implements ViewRef {
  private final String serverUrl;
  private final String databaseName;
  private final String viewName;

  private ImmutableViewRef(String serverUrl, String databaseName, String viewName) {
    this.serverUrl = serverUrl;
    this.databaseName = databaseName;
    this.viewName = viewName;
  }

  /**
   * @return The value of the {@code serverUrl} attribute
   */
  @Override
  public String getServerUrl() {
    return serverUrl;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public String getDatabaseName() {
    return databaseName;
  }

  /**
   * @return The value of the {@code viewName} attribute
   */
  @Override
  public String getViewName() {
    return viewName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewRef#getServerUrl() serverUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableViewRef withServerUrl(String value) {
    String newValue = Objects.requireNonNull(value, "serverUrl");
    if (this.serverUrl.equals(newValue)) return this;
    return new ImmutableViewRef(newValue, this.databaseName, this.viewName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewRef#getDatabaseName() databaseName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for databaseName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableViewRef withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (this.databaseName.equals(newValue)) return this;
    return new ImmutableViewRef(this.serverUrl, newValue, this.viewName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewRef#getViewName() viewName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for viewName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableViewRef withViewName(String value) {
    String newValue = Objects.requireNonNull(value, "viewName");
    if (this.viewName.equals(newValue)) return this;
    return new ImmutableViewRef(this.serverUrl, this.databaseName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableViewRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableViewRef
        && equalTo(0, (ImmutableViewRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableViewRef another) {
    return serverUrl.equals(another.serverUrl)
        && databaseName.equals(another.databaseName)
        && viewName.equals(another.viewName);
  }

  /**
   * Computes a hash code from attributes: {@code serverUrl}, {@code databaseName}, {@code viewName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serverUrl.hashCode();
    h += (h << 5) + databaseName.hashCode();
    h += (h << 5) + viewName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ViewRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewRef{"
        + "serverUrl=" + serverUrl
        + ", databaseName=" + databaseName
        + ", viewName=" + viewName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ViewRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewRef instance
   */
  public static ImmutableViewRef copyOf(ViewRef instance) {
    if (instance instanceof ImmutableViewRef) {
      return (ImmutableViewRef) instance;
    }
    return ImmutableViewRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableViewRef ImmutableViewRef}.
   * <pre>
   * ImmutableViewRef.builder()
   *    .serverUrl(String) // required {@link ViewRef#getServerUrl() serverUrl}
   *    .databaseName(String) // required {@link ViewRef#getDatabaseName() databaseName}
   *    .viewName(String) // required {@link ViewRef#getViewName() viewName}
   *    .build();
   * </pre>
   * @return A new ImmutableViewRef builder
   */
  public static ImmutableViewRef.Builder builder() {
    return new ImmutableViewRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableViewRef ImmutableViewRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ViewRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SERVER_URL = 0x1L;
    private static final long INIT_BIT_DATABASE_NAME = 0x2L;
    private static final long INIT_BIT_VIEW_NAME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String serverUrl;
    private @Nullable String databaseName;
    private @Nullable String viewName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewRef instance) {
      Objects.requireNonNull(instance, "instance");
      this.serverUrl(instance.getServerUrl());
      this.databaseName(instance.getDatabaseName());
      this.viewName(instance.getViewName());
      return this;
    }

    /**
     * Initializes the value for the {@link ViewRef#getServerUrl() serverUrl} attribute.
     * @param serverUrl The value for serverUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serverUrl(String serverUrl) {
      this.serverUrl = Objects.requireNonNull(serverUrl, "serverUrl");
      initBits &= ~INIT_BIT_SERVER_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewRef#getDatabaseName() databaseName} attribute.
     * @param databaseName The value for databaseName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      initBits &= ~INIT_BIT_DATABASE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ViewRef#getViewName() viewName} attribute.
     * @param viewName The value for viewName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder viewName(String viewName) {
      this.viewName = Objects.requireNonNull(viewName, "viewName");
      initBits &= ~INIT_BIT_VIEW_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableViewRef ImmutableViewRef}.
     * @return An immutable instance of ViewRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableViewRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableViewRef(serverUrl, databaseName, viewName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVER_URL) != 0) attributes.add("serverUrl");
      if ((initBits & INIT_BIT_DATABASE_NAME) != 0) attributes.add("databaseName");
      if ((initBits & INIT_BIT_VIEW_NAME) != 0) attributes.add("viewName");
      return "Cannot build ViewRef, some of required attributes are not set " + attributes;
    }
  }
}
