/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.zeepath;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Option;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.source.SourcePath;
import zeenea.connector.source.ZeePath;

public class ZeePaths {
    private static final SimpleLogger log;
    private static final SourcePath.Collation CASE_INSENSITIVE;

    @NotNull
    public static ZeePath zeePath(Path filePath) {
        return (ZeePath)ZeePath.from((String)ZeePaths.nativePath(filePath)).get();
    }

    @NotNull
    public static ZeePath zeePath(List<String> segments) {
        return (ZeePath)ZeePath.from(segments).get();
    }

    @NotNull
    public static String nativePath(Path filePath) {
        ArrayList<String> segments = new ArrayList<String>();
        for (Path name : filePath) {
            segments.add(name.toString());
        }
        return ZeePaths.zeePath(segments).escapedValue();
    }

    @NotNull
    public static String nativePath(List<String> segments) {
        return ZeePaths.zeePath(segments).escapedValue();
    }

    @NotNull
    public static SourcePath sourcePath(@NotNull ZeePath path, @Nullable String label) {
        return label != null ? SourcePath.apply((ZeePath)path, (String)label) : SourcePath.apply((ZeePath)path);
    }

    @NotNull
    public static SourcePath sourcePath(@NotNull ZeePath path) {
        return ZeePaths.sourcePath(path, null);
    }

    @NotNull
    public static SourcePath sourcePath(@NotNull List<String> path, @Nullable String label) {
        return ZeePaths.sourcePath(ZeePaths.zeePath(path), label);
    }

    @NotNull
    public static SourcePath sourcePath(@NotNull List<String> path) {
        return ZeePaths.sourcePath(path, null);
    }

    @NotNull
    public static SourcePath sourcePath(DbEngine engine, @NotNull List<String> path, @Nullable String label) {
        SourcePath.Collation ci = engine.norm() == DbEngine.NameNorm.INSENSITIVE ? CASE_INSENSITIVE : null;
        return SourcePath.apply((ZeePath)ZeePaths.zeePath(path), (Option)Option.apply((Object)label), (Option)Option.apply((Object)ci));
    }

    @NotNull
    public static SourcePath sourcePath(DbEngine engine, @NotNull List<String> path) {
        return ZeePaths.sourcePath(engine, path, null);
    }

    @NotNull
    public static List<String> segments(@NotNull ZeePath path) {
        return path.partsAsStringJavaList();
    }

    static {
        SourcePath.Collation ci;
        log = SimpleLogger.of(ZeePaths.class);
        try {
            ci = SourcePath.caseInsensitive();
        }
        catch (NoSuchMethodError e) {
            try {
                log.entry("commons_zeepaths_sourcepath_case_insensitive_method_not_found").body("Use fallback to get CaseInsensitive collation value.\nIt could be a good idea to update to the scanner 69 or higher if you can.").warn();
                Class<?> klass = Class.forName("zeenea.connector.source.SourcePath$Collation$CaseInsensitive$");
                VarHandle handler = MethodHandles.lookup().in(klass).findStaticVarHandle(klass, "MODULE$", klass);
                ci = handler.get();
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
                log.entry("commons_zeepaths_sourcepath_case_insensitive_collation_not_found_error").body("The current scanner is not compatible.\nPlease update the scanner to 69 or higher.").error();
                ci = null;
            }
        }
        CASE_INSENSITIVE = ci;
    }
}

