/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.collection;

import java.util.Collection;
import java.util.Collections;
import zeenea.connector.commons.collection.Token;

public final class Page<T, E> {
    private final Collection<E> items;
    private final Token<T> nextToken;

    public Page(Collection<E> items, Token<T> nextToken) {
        this.nextToken = nextToken;
        this.items = items;
    }

    public static <T, E> Page<T, E> of(Collection<E> items, Token<T> nextToken) {
        return new Page<T, E>(items, nextToken);
    }

    public static <T, E> Page<T, E> of(Collection<E> items, T nextToken) {
        return Page.of(items, Token.next(nextToken));
    }

    public static <T, E> Page<T, E> last(Collection<E> items) {
        return Page.of(items, Token.last());
    }

    public static <T, E> Page<T, E> empty() {
        return Page.of(Collections.emptyList(), Token.last());
    }

    public Collection<E> getItems() {
        return this.items;
    }

    public Token<T> getNextToken() {
        return this.nextToken;
    }
}

