/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api.quota;

import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.api.quota.AbstractQuota;
import zeenea.connector.commons.api.quota.FixedWindow;
import zeenea.connector.commons.api.quota.QuotaTicket;
import zeenea.connector.commons.log.SimpleLogger;

public class FixedWindowQuota
extends AbstractQuota {
    private static final SimpleLogger log = SimpleLogger.of(FixedWindowQuota.class);
    private final TemporalUnit windowWidth;
    private final int quotaPerWindow;
    private final AtomicReference<FixedWindow> lastWindow;

    FixedWindowQuota(String name, TemporalUnit windowWidth, int quotaPerWindow) {
        super(name);
        this.windowWidth = Objects.requireNonNull(windowWidth, "windowsWidth");
        if (quotaPerWindow <= 0) {
            throw new IllegalArgumentException("quotaPerWindow should be gretter or equals to 1");
        }
        this.quotaPerWindow = quotaPerWindow;
        this.lastWindow = new AtomicReference<FixedWindow>(new FixedWindow(Instant.now(), quotaPerWindow));
    }

    public static FixedWindowQuota of(String name, TemporalUnit windowWidth, int quotaPerWindow) {
        return new FixedWindowQuota(name, windowWidth, quotaPerWindow);
    }

    @Override
    @NotNull
    protected QuotaTicket requestTicket() {
        log.entry("fixed_window_quota_request_ticket").with("name", this.name()).debug();
        long startTime = System.nanoTime();
        QuotaTicket ticket = null;
        do {
            FixedWindow window = this.lastWindow.get();
            Instant windowTimestamp = this.currentWindow();
            if (!windowTimestamp.equals(window.timestamp)) {
                FixedWindow newWindow = new FixedWindow(windowTimestamp, this.quotaPerWindow - 1);
                if (!this.lastWindow.compareAndSet(window, newWindow)) continue;
                ticket = QuotaTicket.granted();
                continue;
            }
            if (window.remainingQuota > 0) {
                if (!this.lastWindow.compareAndSet(window, window.consume())) continue;
                ticket = QuotaTicket.granted();
                continue;
            }
            ticket = QuotaTicket.denied(this.nextWindow());
        } while (ticket == null);
        log.entry("fixed_window_quota_request_ticket_end").startTimeNanos(startTime).with("name", this.name()).with("ticket", ticket).trace();
        return ticket;
    }

    @Override
    public void exhausted() {
        this.lastWindow.updateAndGet(window -> new FixedWindow(this.currentWindow(), 0));
    }

    private Instant currentWindow() {
        return Instant.now().truncatedTo(this.windowWidth);
    }

    private Instant nextWindow() {
        return this.currentWindow().plus(1L, this.windowWidth);
    }
}

