/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectionConfiguration;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.api.CantGuessStoreTypeException;
import zeenea.connector.commons.api.StoreHelper;
import zeenea.connector.commons.api.TrustStoreException;
import zeenea.connector.commons.api.TrustStorePathMissingException;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.config.ConfigPropertyKey;
import zeenea.connector.exception.InvalidConfigurationException;
import zeenea.connector.jdk.ConnectorBuilders;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.PasswordSourceConnectionConfigurationProperty;
import zeenea.connector.source.SourceConnectionConfigurationProperty;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceSection;
import zeenea.connector.source.SourceStringProperty;
import zeenea.connector.source.StringSourceConnectionConfigurationProperty;

public final class TrustStoreConfig {
    private static final SimpleLogger log = SimpleLogger.of(TrustStoreConfig.class);
    public static final String TLS_TRUSTSTORE_PATH_CONF_KEY = "tls.truststore.path";
    public static final StringSourceConnectionConfigurationProperty TLS_TRUSTSTORE_PATH_CONF = ConnectorBuilders.stringConfig((UUID)UUID.fromString("2b31cbbb-60af-4fcb-b9e4-3e724bdac9ca"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.truststore.path"), (String)"TLS/SSL Truststore Path");
    public static final String TLS_TRUSTSTORE_PASSWORD_CONF_KEY = "tls.truststore.password";
    public static final PasswordSourceConnectionConfigurationProperty TLS_TRUSTSTORE_PASSWORD_CONF = ConnectorBuilders.passwordConfig((UUID)UUID.fromString("4bb2cd1f-4519-4070-9980-60407165efec"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.truststore.password"), (String)"TLS/SSL Truststore Password");
    public static final String TLS_TRUSTSTORE_TYPE_CONF_KEY = "tls.truststore.type";
    public static final StringSourceConnectionConfigurationProperty TLS_TRUSTSTORE_TYPE_CONF = ConnectorBuilders.stringConfig((UUID)UUID.fromString("48158775-b77f-4f75-a001-aafe78872546"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.truststore.type"), (String)"TLS/SSL Truststore Type");
    @Deprecated
    public static final StringSourceConnectionConfigurationProperty TLS_PATH_CONF = TLS_TRUSTSTORE_PATH_CONF;
    @Deprecated
    public static final PasswordSourceConnectionConfigurationProperty TLS_PASSWORD_CONF = TLS_TRUSTSTORE_PASSWORD_CONF;
    @Deprecated
    public static final StringSourceConnectionConfigurationProperty TLS_TYPE_CONF = TLS_TRUSTSTORE_TYPE_CONF;
    public static final String TLS_BYPASS_CONF_KEY = "tls.bypass_certificate_validation";
    public static final StringSourceConnectionConfigurationProperty TLS_BYPASS_CONF = ConnectorBuilders.stringConfig((UUID)UUID.fromString("a92e6e92-d65d-4d51-9c31-9c97050bb011"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.bypass_certificate_validation"), (String)"TLS/SSL Bypass Certification validation");
    private final Path storePath;
    private final String storeType;
    private final String storePassword;
    private final boolean bypassValidation;

    public static SourceSection section() {
        return ConnectorBuilders.sourceSection((String)"TLS Trust Store").property((SourceConnectionConfigurationProperty)TLS_TRUSTSTORE_PATH_CONF).property((SourceConnectionConfigurationProperty)TLS_TRUSTSTORE_PASSWORD_CONF).property((SourceConnectionConfigurationProperty)TLS_TRUSTSTORE_TYPE_CONF).property((SourceConnectionConfigurationProperty)TLS_BYPASS_CONF).build();
    }

    public static SourceSection sectionNoBypass() {
        return ConnectorBuilders.sourceSection((String)"TLS Trust Store").property((SourceConnectionConfigurationProperty)TLS_TRUSTSTORE_PATH_CONF).property((SourceConnectionConfigurationProperty)TLS_TRUSTSTORE_PASSWORD_CONF).property((SourceConnectionConfigurationProperty)TLS_TRUSTSTORE_TYPE_CONF).build();
    }

    private TrustStoreConfig(Path truststorePath, String truststoreType, String truststorePassword, boolean bypassValidation) {
        this.storePath = truststorePath;
        this.storeType = truststoreType;
        this.storePassword = truststorePassword;
        this.bypassValidation = bypassValidation;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public static TrustStoreConfig of(PropertyValueMap configuration) throws ConnectorConfigurationException {
        Builder builder = TrustStoreConfig.builder();
        try {
            configuration.get((SourceStringProperty)TLS_TRUSTSTORE_PATH_CONF).ifPresent(builder::storePath);
            configuration.get((SourceStringProperty)TLS_TRUSTSTORE_TYPE_CONF).ifPresent(builder::storeType);
            configuration.get((SourceStringProperty)TLS_TRUSTSTORE_PASSWORD_CONF).ifPresent(builder::storePassword);
            configuration.get((SourceStringProperty)TLS_BYPASS_CONF).ifPresent(builder::bypassValidation);
            return builder.build();
        }
        catch (InvalidPathException | TrustStorePathMissingException e) {
            throw new ConnectorConfigurationException((SourceProperty)TLS_TRUSTSTORE_PATH_CONF, e.getMessage(), (Throwable)e);
        }
        catch (CantGuessStoreTypeException e) {
            throw new ConnectorConfigurationException((SourceProperty)TLS_TRUSTSTORE_TYPE_CONF, e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public static TrustStoreConfig of(ConnectionConfiguration configuration) throws InvalidConfigurationException {
        Builder builder = TrustStoreConfig.builder();
        try {
            configuration.getStringOptional(TLS_TRUSTSTORE_PATH_CONF_KEY).ifPresent(builder::storePath);
            configuration.getStringOptional(TLS_TRUSTSTORE_TYPE_CONF_KEY).ifPresent(builder::storeType);
            configuration.getStringOptional(TLS_TRUSTSTORE_PASSWORD_CONF_KEY).ifPresent(builder::storePassword);
            configuration.getStringOptional(TLS_BYPASS_CONF_KEY).ifPresent(builder::bypassValidation);
            return builder.build();
        }
        catch (InvalidPathException | TrustStorePathMissingException e) {
            throw new InvalidConfigurationException(String.format("%s: %s", TLS_TRUSTSTORE_PATH_CONF_KEY, e.getMessage()), (Throwable)e);
        }
        catch (CantGuessStoreTypeException e) {
            throw new InvalidConfigurationException(String.format("%s: %s", TLS_TRUSTSTORE_TYPE_CONF, e.getMessage()), (Throwable)e);
        }
    }

    public Path getStorePath() {
        return this.storePath;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public boolean isBypassValidation() {
        return this.bypassValidation;
    }

    @Nullable
    public HostnameVerifier createHostnameVerifier() {
        return this.bypassValidation ? GodillotHostNameVerifier.INSTANCE : null;
    }

    public SSLSocketFactory createSSLSocketFactory(TracingContext ctx) {
        return this.createSSLContext(ctx).getSocketFactory();
    }

    public SSLContext createSSLContext(TracingContext ctx) {
        try {
            TrustManager[] trustManagers = this.createTrustManagers(ctx);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustManagers, new SecureRandom());
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw log.entry("truststore_config_create_ssl_socket_factory_failure").context(ctx).with("bypassValidation", this.bypassValidation).with("storePath", this.storePath).with("storeType", this.storeType).exception(e, TrustStoreException::new);
        }
    }

    public TrustManager[] createTrustManagers(TracingContext ctx) {
        if (this.bypassValidation) {
            return TrustAllCertificates.values();
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance(this.storeType);
            try (InputStream input = Files.newInputStream(this.storePath, new OpenOption[0]);){
                char[] password = this.storePassword != null ? this.storePassword.toCharArray() : null;
                keyStore.load(input, password);
            }
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw log.entry("truststore_config_create_trust_managers_failure").context(ctx).with("bypassValidation", this.bypassValidation).with("storePath", this.storePath).with("storeType", this.storeType).exception(e, TrustStoreException::new);
        }
    }

    private static enum GodillotHostNameVerifier implements HostnameVerifier
    {
        INSTANCE;


        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static enum TrustAllCertificates implements X509TrustManager
    {
        INSTANCE;


        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    public static final class Builder {
        private Path storePath;
        private String storeType;
        private String storePassword;
        private boolean bypassValidation;

        public Builder storePath(Path storePath) {
            this.storePath = storePath;
            return this;
        }

        public Builder storePath(String storePath) {
            return this.storePath(storePath != null ? Paths.get(storePath, new String[0]) : null);
        }

        public Builder storeType(String storeType) {
            this.storeType = storeType;
            return this;
        }

        public Builder storePassword(String storePassword) {
            this.storePassword = storePassword;
            return this;
        }

        public Builder bypassValidation(boolean bypassValidation) {
            this.bypassValidation = bypassValidation;
            return this;
        }

        public Builder bypassValidation(String bypassValidation) {
            return this.bypassValidation(Boolean.parseBoolean(bypassValidation));
        }

        @Nullable
        public TrustStoreConfig build() {
            if (!this.bypassValidation && this.storePath == null) {
                return null;
            }
            String type = null;
            if (!this.bypassValidation) {
                if (!Files.exists(this.storePath, new LinkOption[0])) {
                    throw new TrustStorePathMissingException("truststore_config_store_path_doesnt_exist '" + this.storePath + "'");
                }
                if (!Files.isRegularFile(this.storePath, new LinkOption[0])) {
                    throw new TrustStorePathMissingException("truststore_config_store_path_isnt_regular_file '" + this.storePath + "'");
                }
                if (!Files.isReadable(this.storePath)) {
                    throw new TrustStorePathMissingException("truststore_config_store_path_cant_be_read '" + this.storePath + "'");
                }
                type = this.storeType != null ? this.storeType : StoreHelper.storeTypeFromExtension(this.storePath);
            }
            return new TrustStoreConfig(this.storePath, type, this.storePassword, this.bypassValidation);
        }
    }
}

