package zeenea.connector.dbt.etl.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.dbt.etl.json.catalog.DbtCatalog;
import zeenea.connector.dbt.etl.json.manifest.DbtManifest;
import zeenea.connector.dbt.etl.json.profile.DbtProfileMap;
import zeenea.connector.dbt.etl.json.project.DbtProject;

/**
 * Immutable implementation of {@link ProjectHandle}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectHandle.builder()}.
 */
@Generated(from = "ProjectHandle", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProjectHandle extends ProjectHandle {
  private final FsUrl root;
  private final FsPath path;
  private final DbtProject dbtProject;
  private final DbtManifest manifest;
  private final @Nullable DbtCatalog catalog;
  private final @Nullable DbtProfileMap profiles;

  private ImmutableProjectHandle(
      FsUrl root,
      FsPath path,
      DbtProject dbtProject,
      DbtManifest manifest,
      @Nullable DbtCatalog catalog,
      @Nullable DbtProfileMap profiles) {
    this.root = root;
    this.path = path;
    this.dbtProject = dbtProject;
    this.manifest = manifest;
    this.catalog = catalog;
    this.profiles = profiles;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public FsUrl root() {
    return root;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public FsPath path() {
    return path;
  }

  /**
   * @return The value of the {@code dbtProject} attribute
   */
  @Override
  public DbtProject dbtProject() {
    return dbtProject;
  }

  /**
   * @return The value of the {@code manifest} attribute
   */
  @Override
  public DbtManifest manifest() {
    return manifest;
  }

  /**
   * @return The value of the {@code catalog} attribute
   */
  @Override
  public @Nullable DbtCatalog catalog() {
    return catalog;
  }

  /**
   * @return The value of the {@code profiles} attribute
   */
  @Override
  public @Nullable DbtProfileMap profiles() {
    return profiles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectHandle#root() root} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for root
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectHandle withRoot(FsUrl value) {
    if (this.root == value) return this;
    FsUrl newValue = Objects.requireNonNull(value, "root");
    return new ImmutableProjectHandle(newValue, this.path, this.dbtProject, this.manifest, this.catalog, this.profiles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectHandle#path() path} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectHandle withPath(FsPath value) {
    if (this.path == value) return this;
    FsPath newValue = Objects.requireNonNull(value, "path");
    return new ImmutableProjectHandle(this.root, newValue, this.dbtProject, this.manifest, this.catalog, this.profiles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectHandle#dbtProject() dbtProject} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dbtProject
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectHandle withDbtProject(DbtProject value) {
    if (this.dbtProject == value) return this;
    DbtProject newValue = Objects.requireNonNull(value, "dbtProject");
    return new ImmutableProjectHandle(this.root, this.path, newValue, this.manifest, this.catalog, this.profiles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectHandle#manifest() manifest} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for manifest
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectHandle withManifest(DbtManifest value) {
    if (this.manifest == value) return this;
    DbtManifest newValue = Objects.requireNonNull(value, "manifest");
    return new ImmutableProjectHandle(this.root, this.path, this.dbtProject, newValue, this.catalog, this.profiles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectHandle#catalog() catalog} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalog (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectHandle withCatalog(@Nullable DbtCatalog value) {
    if (this.catalog == value) return this;
    return new ImmutableProjectHandle(this.root, this.path, this.dbtProject, this.manifest, value, this.profiles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectHandle#profiles() profiles} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for profiles (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectHandle withProfiles(@Nullable DbtProfileMap value) {
    if (this.profiles == value) return this;
    return new ImmutableProjectHandle(this.root, this.path, this.dbtProject, this.manifest, this.catalog, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectHandle} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectHandle
        && equalTo(0, (ImmutableProjectHandle) another);
  }

  private boolean equalTo(int synthetic, ImmutableProjectHandle another) {
    return root.equals(another.root)
        && path.equals(another.path)
        && dbtProject.equals(another.dbtProject)
        && manifest.equals(another.manifest)
        && Objects.equals(catalog, another.catalog)
        && Objects.equals(profiles, another.profiles);
  }

  /**
   * Computes a hash code from attributes: {@code root}, {@code path}, {@code dbtProject}, {@code manifest}, {@code catalog}, {@code profiles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + root.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + dbtProject.hashCode();
    h += (h << 5) + manifest.hashCode();
    h += (h << 5) + Objects.hashCode(catalog);
    h += (h << 5) + Objects.hashCode(profiles);
    return h;
  }

  /**
   * Creates an immutable copy of a {@link ProjectHandle} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProjectHandle instance
   */
  public static ImmutableProjectHandle copyOf(ProjectHandle instance) {
    if (instance instanceof ImmutableProjectHandle) {
      return (ImmutableProjectHandle) instance;
    }
    return ImmutableProjectHandle.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProjectHandle ImmutableProjectHandle}.
   * <pre>
   * ImmutableProjectHandle.builder()
   *    .root(zeenea.connector.commons.fsclient.FsUrl) // required {@link ProjectHandle#root() root}
   *    .path(zeenea.connector.commons.fsclient.FsPath) // required {@link ProjectHandle#path() path}
   *    .dbtProject(zeenea.connector.dbt.etl.json.project.DbtProject) // required {@link ProjectHandle#dbtProject() dbtProject}
   *    .manifest(zeenea.connector.dbt.etl.json.manifest.DbtManifest) // required {@link ProjectHandle#manifest() manifest}
   *    .catalog(zeenea.connector.dbt.etl.json.catalog.DbtCatalog | null) // nullable {@link ProjectHandle#catalog() catalog}
   *    .profiles(zeenea.connector.dbt.etl.json.profile.DbtProfileMap | null) // nullable {@link ProjectHandle#profiles() profiles}
   *    .build();
   * </pre>
   * @return A new ImmutableProjectHandle builder
   */
  public static ImmutableProjectHandle.Builder builder() {
    return new ImmutableProjectHandle.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectHandle ImmutableProjectHandle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProjectHandle", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ROOT = 0x1L;
    private static final long INIT_BIT_PATH = 0x2L;
    private static final long INIT_BIT_DBT_PROJECT = 0x4L;
    private static final long INIT_BIT_MANIFEST = 0x8L;
    private long initBits = 0xfL;

    private @javax.annotation.Nullable FsUrl root;
    private @javax.annotation.Nullable FsPath path;
    private @javax.annotation.Nullable DbtProject dbtProject;
    private @javax.annotation.Nullable DbtManifest manifest;
    private @javax.annotation.Nullable DbtCatalog catalog;
    private @javax.annotation.Nullable DbtProfileMap profiles;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectHandle} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ProjectHandle instance) {
      Objects.requireNonNull(instance, "instance");
      this.root(instance.root());
      this.path(instance.path());
      this.dbtProject(instance.dbtProject());
      this.manifest(instance.manifest());
      @Nullable DbtCatalog catalogValue = instance.catalog();
      if (catalogValue != null) {
        catalog(catalogValue);
      }
      @Nullable DbtProfileMap profilesValue = instance.profiles();
      if (profilesValue != null) {
        profiles(profilesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectHandle#root() root} attribute.
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder root(FsUrl root) {
      this.root = Objects.requireNonNull(root, "root");
      initBits &= ~INIT_BIT_ROOT;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectHandle#path() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(FsPath path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectHandle#dbtProject() dbtProject} attribute.
     * @param dbtProject The value for dbtProject 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dbtProject(DbtProject dbtProject) {
      this.dbtProject = Objects.requireNonNull(dbtProject, "dbtProject");
      initBits &= ~INIT_BIT_DBT_PROJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectHandle#manifest() manifest} attribute.
     * @param manifest The value for manifest 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder manifest(DbtManifest manifest) {
      this.manifest = Objects.requireNonNull(manifest, "manifest");
      initBits &= ~INIT_BIT_MANIFEST;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectHandle#catalog() catalog} attribute.
     * @param catalog The value for catalog (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder catalog(@Nullable DbtCatalog catalog) {
      this.catalog = catalog;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectHandle#profiles() profiles} attribute.
     * @param profiles The value for profiles (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder profiles(@Nullable DbtProfileMap profiles) {
      this.profiles = profiles;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectHandle ImmutableProjectHandle}.
     * @return An immutable instance of ProjectHandle
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectHandle build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectHandle(root, path, dbtProject, manifest, catalog, profiles);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROOT) != 0) attributes.add("root");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_DBT_PROJECT) != 0) attributes.add("dbtProject");
      if ((initBits & INIT_BIT_MANIFEST) != 0) attributes.add("manifest");
      return "Cannot build ProjectHandle, some of required attributes are not set " + attributes;
    }
  }
}
