package zeenea.connector.dbt.etl.client;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.dbt.etl.json.common.DbtUniqueId;

/**
 * Immutable implementation of {@link ItemHandle}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemHandle.builder()}.
 */
@Generated(from = "ItemHandle", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableItemHandle extends ItemHandle {
  private final ProjectHandle project;
  private final DbtUniqueId uniqueId;

  private ImmutableItemHandle(
      ProjectHandle project,
      DbtUniqueId uniqueId) {
    this.project = project;
    this.uniqueId = uniqueId;
  }

  /**
   * @return The value of the {@code project} attribute
   */
  @Override
  public ProjectHandle project() {
    return project;
  }

  /**
   * @return The value of the {@code uniqueId} attribute
   */
  @Override
  public DbtUniqueId uniqueId() {
    return uniqueId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemHandle#project() project} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for project
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemHandle withProject(ProjectHandle value) {
    if (this.project == value) return this;
    ProjectHandle newValue = Objects.requireNonNull(value, "project");
    return new ImmutableItemHandle(newValue, this.uniqueId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemHandle#uniqueId() uniqueId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for uniqueId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemHandle withUniqueId(DbtUniqueId value) {
    if (this.uniqueId == value) return this;
    DbtUniqueId newValue = Objects.requireNonNull(value, "uniqueId");
    return new ImmutableItemHandle(this.project, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemHandle} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemHandle
        && equalTo(0, (ImmutableItemHandle) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemHandle another) {
    return project.equals(another.project)
        && uniqueId.equals(another.uniqueId);
  }

  /**
   * Computes a hash code from attributes: {@code project}, {@code uniqueId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + project.hashCode();
    h += (h << 5) + uniqueId.hashCode();
    return h;
  }

  /**
   * Creates an immutable copy of a {@link ItemHandle} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemHandle instance
   */
  public static ImmutableItemHandle copyOf(ItemHandle instance) {
    if (instance instanceof ImmutableItemHandle) {
      return (ImmutableItemHandle) instance;
    }
    return ImmutableItemHandle.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemHandle ImmutableItemHandle}.
   * <pre>
   * ImmutableItemHandle.builder()
   *    .project(zeenea.connector.dbt.etl.client.ProjectHandle) // required {@link ItemHandle#project() project}
   *    .uniqueId(zeenea.connector.dbt.etl.json.common.DbtUniqueId) // required {@link ItemHandle#uniqueId() uniqueId}
   *    .build();
   * </pre>
   * @return A new ImmutableItemHandle builder
   */
  public static ImmutableItemHandle.Builder builder() {
    return new ImmutableItemHandle.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemHandle ImmutableItemHandle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemHandle", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROJECT = 0x1L;
    private static final long INIT_BIT_UNIQUE_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ProjectHandle project;
    private @Nullable DbtUniqueId uniqueId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemHandle} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ItemHandle instance) {
      Objects.requireNonNull(instance, "instance");
      this.project(instance.project());
      this.uniqueId(instance.uniqueId());
      return this;
    }

    /**
     * Initializes the value for the {@link ItemHandle#project() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder project(ProjectHandle project) {
      this.project = Objects.requireNonNull(project, "project");
      initBits &= ~INIT_BIT_PROJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemHandle#uniqueId() uniqueId} attribute.
     * @param uniqueId The value for uniqueId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder uniqueId(DbtUniqueId uniqueId) {
      this.uniqueId = Objects.requireNonNull(uniqueId, "uniqueId");
      initBits &= ~INIT_BIT_UNIQUE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemHandle ImmutableItemHandle}.
     * @return An immutable instance of ItemHandle
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemHandle build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItemHandle(project, uniqueId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT) != 0) attributes.add("project");
      if ((initBits & INIT_BIT_UNIQUE_ID) != 0) attributes.add("uniqueId");
      return "Cannot build ItemHandle, some of required attributes are not set " + attributes;
    }
  }
}
