package zeenea.connector.dbt.etl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.FsUrl;

/**
 * Immutable implementation of {@link DbtConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDbtConfiguration.builder()}.
 */
@Generated(from = "DbtConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDbtConfiguration implements DbtConfiguration {
  private final String connectionCode;
  private final FsUrl root;
  private final boolean multiCatalog;
  private final @Nullable FsUrl profilePath;
  private final @Nullable String targetName;

  private ImmutableDbtConfiguration(
      String connectionCode,
      FsUrl root,
      boolean multiCatalog,
      @Nullable FsUrl profilePath,
      @Nullable String targetName) {
    this.connectionCode = connectionCode;
    this.root = root;
    this.multiCatalog = multiCatalog;
    this.profilePath = profilePath;
    this.targetName = targetName;
  }

  /**
   * @return The value of the {@code connectionCode} attribute
   */
  @Override
  public String connectionCode() {
    return connectionCode;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public FsUrl root() {
    return root;
  }

  /**
   * @return The value of the {@code multiCatalog} attribute
   */
  @Override
  public boolean isMultiCatalog() {
    return multiCatalog;
  }

  /**
   * @return The value of the {@code profilePath} attribute
   */
  @Override
  public @Nullable FsUrl profilePath() {
    return profilePath;
  }

  /**
   * @return The value of the {@code targetName} attribute
   */
  @Override
  public @Nullable String targetName() {
    return targetName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DbtConfiguration#connectionCode() connectionCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDbtConfiguration withConnectionCode(String value) {
    String newValue = Objects.requireNonNull(value, "connectionCode");
    if (this.connectionCode.equals(newValue)) return this;
    return new ImmutableDbtConfiguration(newValue, this.root, this.multiCatalog, this.profilePath, this.targetName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DbtConfiguration#root() root} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for root
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDbtConfiguration withRoot(FsUrl value) {
    if (this.root == value) return this;
    FsUrl newValue = Objects.requireNonNull(value, "root");
    return new ImmutableDbtConfiguration(this.connectionCode, newValue, this.multiCatalog, this.profilePath, this.targetName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DbtConfiguration#isMultiCatalog() multiCatalog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiCatalog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDbtConfiguration withMultiCatalog(boolean value) {
    if (this.multiCatalog == value) return this;
    return new ImmutableDbtConfiguration(this.connectionCode, this.root, value, this.profilePath, this.targetName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DbtConfiguration#profilePath() profilePath} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for profilePath (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDbtConfiguration withProfilePath(@Nullable FsUrl value) {
    if (this.profilePath == value) return this;
    return new ImmutableDbtConfiguration(this.connectionCode, this.root, this.multiCatalog, value, this.targetName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DbtConfiguration#targetName() targetName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDbtConfiguration withTargetName(@Nullable String value) {
    if (Objects.equals(this.targetName, value)) return this;
    return new ImmutableDbtConfiguration(this.connectionCode, this.root, this.multiCatalog, this.profilePath, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDbtConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDbtConfiguration
        && equalTo(0, (ImmutableDbtConfiguration) another);
  }

  private boolean equalTo(int synthetic, ImmutableDbtConfiguration another) {
    return connectionCode.equals(another.connectionCode)
        && root.equals(another.root)
        && multiCatalog == another.multiCatalog
        && Objects.equals(profilePath, another.profilePath)
        && Objects.equals(targetName, another.targetName);
  }

  /**
   * Computes a hash code from attributes: {@code connectionCode}, {@code root}, {@code multiCatalog}, {@code profilePath}, {@code targetName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + connectionCode.hashCode();
    h += (h << 5) + root.hashCode();
    h += (h << 5) + Boolean.hashCode(multiCatalog);
    h += (h << 5) + Objects.hashCode(profilePath);
    h += (h << 5) + Objects.hashCode(targetName);
    return h;
  }

  /**
   * Prints the immutable value {@code DbtConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DbtConfiguration{"
        + "connectionCode=" + connectionCode
        + ", root=" + root
        + ", multiCatalog=" + multiCatalog
        + ", profilePath=" + profilePath
        + ", targetName=" + targetName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DbtConfiguration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DbtConfiguration instance
   */
  public static ImmutableDbtConfiguration copyOf(DbtConfiguration instance) {
    if (instance instanceof ImmutableDbtConfiguration) {
      return (ImmutableDbtConfiguration) instance;
    }
    return ImmutableDbtConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDbtConfiguration ImmutableDbtConfiguration}.
   * <pre>
   * ImmutableDbtConfiguration.builder()
   *    .connectionCode(String) // required {@link DbtConfiguration#connectionCode() connectionCode}
   *    .root(zeenea.connector.commons.fsclient.FsUrl) // required {@link DbtConfiguration#root() root}
   *    .multiCatalog(boolean) // required {@link DbtConfiguration#isMultiCatalog() multiCatalog}
   *    .profilePath(zeenea.connector.commons.fsclient.FsUrl | null) // nullable {@link DbtConfiguration#profilePath() profilePath}
   *    .targetName(String | null) // nullable {@link DbtConfiguration#targetName() targetName}
   *    .build();
   * </pre>
   * @return A new ImmutableDbtConfiguration builder
   */
  public static ImmutableDbtConfiguration.Builder builder() {
    return new ImmutableDbtConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDbtConfiguration ImmutableDbtConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DbtConfiguration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_CODE = 0x1L;
    private static final long INIT_BIT_ROOT = 0x2L;
    private static final long INIT_BIT_MULTI_CATALOG = 0x4L;
    private long initBits = 0x7L;

    private @javax.annotation.Nullable String connectionCode;
    private @javax.annotation.Nullable FsUrl root;
    private boolean multiCatalog;
    private @javax.annotation.Nullable FsUrl profilePath;
    private @javax.annotation.Nullable String targetName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DbtConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DbtConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      this.connectionCode(instance.connectionCode());
      this.root(instance.root());
      this.multiCatalog(instance.isMultiCatalog());
      @Nullable FsUrl profilePathValue = instance.profilePath();
      if (profilePathValue != null) {
        profilePath(profilePathValue);
      }
      @Nullable String targetNameValue = instance.targetName();
      if (targetNameValue != null) {
        targetName(targetNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DbtConfiguration#connectionCode() connectionCode} attribute.
     * @param connectionCode The value for connectionCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder connectionCode(String connectionCode) {
      this.connectionCode = Objects.requireNonNull(connectionCode, "connectionCode");
      initBits &= ~INIT_BIT_CONNECTION_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link DbtConfiguration#root() root} attribute.
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder root(FsUrl root) {
      this.root = Objects.requireNonNull(root, "root");
      initBits &= ~INIT_BIT_ROOT;
      return this;
    }

    /**
     * Initializes the value for the {@link DbtConfiguration#isMultiCatalog() multiCatalog} attribute.
     * @param multiCatalog The value for multiCatalog 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder multiCatalog(boolean multiCatalog) {
      this.multiCatalog = multiCatalog;
      initBits &= ~INIT_BIT_MULTI_CATALOG;
      return this;
    }

    /**
     * Initializes the value for the {@link DbtConfiguration#profilePath() profilePath} attribute.
     * @param profilePath The value for profilePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder profilePath(@Nullable FsUrl profilePath) {
      this.profilePath = profilePath;
      return this;
    }

    /**
     * Initializes the value for the {@link DbtConfiguration#targetName() targetName} attribute.
     * @param targetName The value for targetName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targetName(@Nullable String targetName) {
      this.targetName = targetName;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDbtConfiguration ImmutableDbtConfiguration}.
     * @return An immutable instance of DbtConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDbtConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDbtConfiguration(connectionCode, root, multiCatalog, profilePath, targetName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_CODE) != 0) attributes.add("connectionCode");
      if ((initBits & INIT_BIT_ROOT) != 0) attributes.add("root");
      if ((initBits & INIT_BIT_MULTI_CATALOG) != 0) attributes.add("multiCatalog");
      return "Cannot build DbtConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
