/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.fsclient.BucketFsUrl;
import zeenea.connector.commons.fsclient.FsClient;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.commons.fsclient.S3Config;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;
import zeenea.connector.commons.proxy.ProxyCommonConfiguration;
import zeenea.connector.source.SourceProperty;

public final class S3FsClient
extends FsClient {
    private static final SimpleLogger log = SimpleLogger.of(S3FsClient.class);
    private final S3Client client;

    private S3FsClient(S3Client client) {
        this.client = client;
    }

    public static S3FsClient create(S3Config config) {
        Proxy proxy;
        URI endpoint;
        S3ClientBuilder s3Builder = (S3ClientBuilder)S3Client.builder().region(config.region());
        AwsCredentialsProvider credentialsProvider = config.credentialsProvider();
        if (credentialsProvider != null) {
            s3Builder.credentialsProvider(credentialsProvider);
        }
        if ((endpoint = config.awsEndpoint()) != null) {
            s3Builder.endpointOverride(endpoint);
        }
        if ((proxy = config.proxy()) != null) {
            ApacheHttpClient.Builder httpClientBuilder = S3FsClient.createHttpClientBuilder(proxy);
            s3Builder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        return new S3FsClient((S3Client)s3Builder.build());
    }

    @NotNull
    private static ApacheHttpClient.Builder createHttpClientBuilder(Proxy proxy) {
        URI proxyEndpoint;
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
        String scheme = proxy.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        try {
            proxyEndpoint = new URI(scheme, null, proxy.getHostname(), proxy.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw (ConnectorConfigurationException)log.entry("dbt_factory_set_proxy_invalid_endpoint").with("scheme", (Object)scheme).with("hostname", (Object)proxy.getHostname()).with("port", (Object)proxy.getPort()).exception((Throwable)e, (m, ex) -> new ConnectorConfigurationException((SourceProperty)ProxyCommonConfiguration.PROXY_HOSTNAME, m, (Throwable)ex));
        }
        builder.endpoint(proxyEndpoint);
        builder.username(proxy.getUsername());
        builder.password(proxy.getPassword());
        httpClientBuilder.proxyConfiguration((ProxyConfiguration)builder.build());
        return httpClientBuilder;
    }

    @Override
    public Stream<FsPath> listFiles(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_s3_list_files").context(ctx).with("url", (Object)url).debug();
        BucketFsUrl s3Url = S3FsClient.checkUrl(ctx, url);
        FsPath prefix = url.path();
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(s3Url.bucket()).prefix(!prefix.isEmpty() ? String.valueOf(prefix) + "/" : null).build();
        ListObjectsV2Iterable response = this.client.listObjectsV2Paginator(request);
        return response.contents().stream().map(s3Object -> prefix.relativize(FsPath.of(s3Object.key())));
    }

    @Override
    public InputStream inputStream(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_s3_input_stream").context(ctx).with("url", (Object)url).debug();
        BucketFsUrl s3Url = S3FsClient.checkUrl(ctx, url);
        try {
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(s3Url.bucket()).key(url.path().toString()).build();
            ResponseBytes response = this.client.getObjectAsBytes(request);
            return response.asInputStream();
        }
        catch (NoSuchKeyException e) {
            log.entry("fs_client_s3_input_stream_no_such_key").with("url", (Object)url).debug();
            return null;
        }
    }

    private static BucketFsUrl checkUrl(TracingContext ctx, FsUrl url) {
        if (!(url instanceof BucketFsUrl) || url.fsName() != FsName.S3) {
            throw (IllegalArgumentException)log.entry("fs_client_s3_unsupported_url").context(ctx).with("url", (Object)url).with("class", (Object)url.getClass().getName()).exception(IllegalArgumentException::new);
        }
        return (BucketFsUrl)url;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

