/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectionConfiguration;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.configuration.GcpConfiguration;
import zeenea.connector.commons.fsclient.ImmutableGsConfig;
import zeenea.connector.commons.immutables.ImmutablePojo;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceStringProperty;

@ImmutablePojo
public abstract class GsConfig {
    private static final SimpleLogger log = SimpleLogger.of(GsConfig.class);

    @Nullable
    public abstract Proxy proxy();

    public abstract Credentials credentials();

    public abstract String projectId();

    public static GsConfig parse(TracingContext ctx, PropertyValueMap configuration) {
        log.entry("fs_client_gs_config_parse").context(ctx).debug();
        return ImmutableGsConfig.builder().proxy(Proxy.builder().configuration(configuration).build()).credentials(GsConfig.googleCredentials(ctx, configuration)).projectId(configuration.getRequired((SourceStringProperty)GcpConfiguration.GCP_PROJECT_ID)).build();
    }

    public static GsConfig parse(TracingContext ctx, ConnectionConfiguration configuration) {
        log.entry("fs_client_gs_config_parse").context(ctx).debug();
        return ImmutableGsConfig.builder().proxy(Proxy.builder().configuration(configuration).build()).credentials(GsConfig.googleCredentials(ctx, configuration)).projectId(configuration.getString(GcpConfiguration.GCP_PROJECT_ID.key().name())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Credentials googleCredentials(TracingContext ctx, PropertyValueMap configuration) {
        ServiceAccountCredentials serviceAccountCredentials;
        InputStream in;
        String jsonKey = configuration.getRequired((SourceStringProperty)GcpConfiguration.GCP_JSON_KEY);
        if (jsonKey.startsWith("file:")) {
            Path jsonKeyPath;
            try {
                jsonKeyPath = Path.of(new URI(jsonKey));
            }
            catch (URISyntaxException e) {
                throw (ConnectorConfigurationException)log.entry("fs_client_gs_config_google_credentials_invalid_json_key").context(ctx).exception((Throwable)e, (msg, ex) -> new ConnectorConfigurationException((SourceProperty)GcpConfiguration.GCP_JSON_KEY, msg, (Throwable)e));
            }
            try {
                in = Files.newInputStream(jsonKeyPath, new OpenOption[0]);
            }
            catch (FileNotFoundException e) {
                throw (ConnectorConfigurationException)log.entry("fs_client_gs_config_google_credentials_json_key_not_found").context(ctx).with("json_key", (Object)jsonKeyPath).exception((Throwable)e, (msg, ex) -> new ConnectorConfigurationException((SourceProperty)GcpConfiguration.GCP_JSON_KEY, msg, (Throwable)e));
            }
        }
        in = new ByteArrayInputStream(jsonKey.getBytes(StandardCharsets.UTF_8));
        try {
            serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                throw (ConnectorConfigurationException)log.entry("fs_client_gs_config_google_credentials_json_key_reading_failure").context(ctx).exception((Throwable)e, (msg, ex) -> new ConnectorConfigurationException((SourceProperty)GcpConfiguration.GCP_JSON_KEY, msg, (Throwable)e));
            }
        }
        ((InputStream)in).close();
        return serviceAccountCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Credentials googleCredentials(TracingContext ctx, ConnectionConfiguration configuration) {
        ServiceAccountCredentials serviceAccountCredentials;
        InputStream in;
        String jsonKey = configuration.getString(GcpConfiguration.GCP_JSON_KEY.key().name());
        if (jsonKey.startsWith("file:")) {
            Path jsonKeyPath;
            try {
                jsonKeyPath = Path.of(new URI(jsonKey));
            }
            catch (URISyntaxException e) {
                throw (ConnectorConfigurationException)log.entry("fs_client_gs_config_google_credentials_invalid_json_key").context(ctx).exception((Throwable)e, (msg, ex) -> new ConnectorConfigurationException((SourceProperty)GcpConfiguration.GCP_JSON_KEY, msg, (Throwable)e));
            }
            try {
                in = Files.newInputStream(jsonKeyPath, new OpenOption[0]);
            }
            catch (FileNotFoundException e) {
                throw (ConnectorConfigurationException)log.entry("fs_client_gs_config_google_credentials_json_key_not_found").context(ctx).with("json_key", (Object)jsonKeyPath).exception((Throwable)e, (msg, ex) -> new ConnectorConfigurationException((SourceProperty)GcpConfiguration.GCP_JSON_KEY, msg, (Throwable)e));
            }
        }
        in = new ByteArrayInputStream(jsonKey.getBytes(StandardCharsets.UTF_8));
        try {
            serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                throw (ConnectorConfigurationException)log.entry("fs_client_gs_config_google_credentials_json_key_reading_failure").context(ctx).exception((Throwable)e, (msg, ex) -> new ConnectorConfigurationException((SourceProperty)GcpConfiguration.GCP_JSON_KEY, msg, (Throwable)e));
            }
        }
        ((InputStream)in).close();
        return serviceAccountCredentials;
    }
}

