/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import zeenea.connector.commons.fsclient.FileFsUrl;
import zeenea.connector.commons.fsclient.FsClient;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;

public class FileFsClient
extends FsClient {
    private static final SimpleLogger log = SimpleLogger.of(FileFsClient.class);

    @Override
    public Stream<FsPath> listFiles(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_file_client_list_files").context(ctx).with("url", (Object)url).debug();
        FileFsUrl fileUrl = FileFsClient.checkProtocol(ctx, url);
        Path path = fileUrl.toFilePath();
        try {
            return Files.walk(path, new FileVisitOption[0]).map(p -> FsPath.of(path.relativize((Path)p))).filter(fsPath -> fsPath.name().isPresent() && !fsPath.name().get().isEmpty());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public InputStream inputStream(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_file_client_input_stream").context(ctx).with("url", (Object)url).debug();
        FileFsUrl fileUrl = FileFsClient.checkProtocol(ctx, url);
        Path path = fileUrl.toFilePath();
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            log.entry("fs_client_file_client_input_stream_no_such_file").with("url", (Object)url).debug();
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static FileFsUrl checkProtocol(TracingContext ctx, FsUrl url) {
        if (!(url instanceof FileFsUrl)) {
            throw (IllegalArgumentException)log.entry("fs_client_file_client_unsupported_protocol").context(ctx).with("url", (Object)url).exception(IllegalArgumentException::new);
        }
        return (FileFsUrl)url;
    }

    @Override
    public void close() {
    }
}

