/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;

public class BucketFsUrl
extends FsUrl {
    private final FsName fsName;
    private final String bucket;

    BucketFsUrl(@NotNull FsName fsName, @NotNull String bucket, @NotNull FsPath path) {
        super(path);
        this.fsName = Objects.requireNonNull(fsName);
        this.bucket = Objects.requireNonNull(bucket);
    }

    @Override
    public FsName fsName() {
        return this.fsName;
    }

    public String bucket() {
        return this.bucket;
    }

    @Override
    FsUrl withPath(FsPath path) {
        return new BucketFsUrl(this.fsName, this.bucket, path);
    }

    public String toString() {
        return this.fsName.protocol() + "://" + this.bucket + "/" + this.path().toString();
    }
}

