/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;

public class Adls2FsUrl
extends FsUrl {
    @NotNull
    private final String host;
    @NotNull
    private final String container;

    Adls2FsUrl(@NotNull String host, @NotNull String container, @NotNull FsPath path) {
        super(path);
        this.host = Objects.requireNonNull(host);
        this.container = Objects.requireNonNull(container);
    }

    @Override
    public FsName fsName() {
        return FsName.ADLS2;
    }

    public String host() {
        return this.host;
    }

    public String container() {
        return this.container;
    }

    @Override
    FsUrl withPath(FsPath path) {
        return new Adls2FsUrl(this.host, this.container, path);
    }

    public String toString() {
        return "https://" + this.host + "/" + this.container + "/" + this.path().toString();
    }
}

