/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.collection.Page;
import zeenea.connector.commons.collection.Token;

public class PaginatedIterable<T, E>
implements Iterable<E> {
    private final Token<T> firstToken;
    @NotNull
    private final @NotNull Function<@NotNull Token<T>, Page<T, E>> pageFetcher;

    private PaginatedIterable(Token<T> firstToken, @NotNull Function<Token<T>, Page<T, E>> pageFetcher) {
        this.firstToken = Objects.requireNonNull(firstToken, "firstToken");
        this.pageFetcher = Objects.requireNonNull(pageFetcher, "pageFetcher");
    }

    public static <T, E> PaginatedIterable<T, E> of(T firstToken, @NotNull Function<Token<T>, Page<T, E>> pageFetcher) {
        return new PaginatedIterable<T, E>(Token.first(firstToken), pageFetcher);
    }

    public static <T, E> PaginatedIterable<T, E> of(@NotNull Function<Token<T>, Page<T, E>> pageFetcher) {
        return new PaginatedIterable(Token.first(), pageFetcher);
    }

    public static <T, E> PaginatedIterable<T, E> empty() {
        return new PaginatedIterable(Token.last(), __ -> Page.empty());
    }

    public static <E> PaginatedIterable<Integer, E> byOffset(int firstIndex, @NotNull IntFunction<? extends Collection<E>> pageFetcher) {
        return new PaginatedIterable<Integer, E>(Token.first(firstIndex), token -> {
            int index = (Integer)token.getValue();
            Collection items = (Collection)pageFetcher.apply(index);
            return items != null && !items.isEmpty() ? Page.of(items, index + items.size()) : Page.last(items);
        });
    }

    public static <E> PaginatedIterable<Integer, E> byOffset(@NotNull IntFunction<? extends Collection<E>> pageFetcher) {
        return PaginatedIterable.byOffset(0, pageFetcher);
    }

    public static <E> PaginatedIterable<Long, E> byLongOffset(long firstIndex, @NotNull LongFunction<? extends Collection<E>> pageFetcher) {
        return new PaginatedIterable<Long, E>(Token.first(firstIndex), token -> {
            long index = (Long)token.getValue();
            Collection items = (Collection)pageFetcher.apply(index);
            return items != null && !items.isEmpty() ? Page.of(items, index + (long)items.size()) : Page.last(items);
        });
    }

    public static <E> PaginatedIterable<Long, E> byLongOffset(@NotNull LongFunction<? extends Collection<E>> pageFetcher) {
        return PaginatedIterable.byLongOffset(0L, pageFetcher);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new PaginatedIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return new PaginatedSpiterator();
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private class PaginatedSpiterator
    implements Spliterator<E> {
        private Token<T> nextToken;
        private Spliterator<E> pageIterator;

        private PaginatedSpiterator() {
            this.nextToken = PaginatedIterable.this.firstToken;
        }

        private boolean fetch() {
            if (this.nextToken.isLast()) {
                return false;
            }
            Page page = PaginatedIterable.this.pageFetcher.apply(this.nextToken);
            if (page != null && !page.getNextToken().equals(this.nextToken) && !page.getItems().isEmpty()) {
                this.nextToken = page.getNextToken();
                this.pageIterator = page.getItems().spliterator();
                return true;
            }
            return false;
        }

        private void init() {
            if (this.pageIterator == null && !this.fetch()) {
                this.pageIterator = Spliterators.emptySpliterator();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            this.init();
            if (this.pageIterator.tryAdvance(action)) {
                return true;
            }
            if (this.fetch()) {
                return this.pageIterator.tryAdvance(action);
            }
            return false;
        }

        @Override
        public Spliterator<E> trySplit() {
            this.init();
            Spliterator split = this.pageIterator;
            return this.fetch() ? split : null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }

    private class PaginatedIterator
    implements Iterator<E> {
        private Token<T> nextToken;
        private boolean alive;
        private E next;
        private Iterator<E> pageIterator;

        private PaginatedIterator() {
            this.nextToken = PaginatedIterable.this.firstToken;
            this.alive = true;
            this.pageIterator = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.alive && this.next != null) {
                return true;
            }
            while (this.alive) {
                if (this.pageIterator.hasNext()) {
                    this.next = this.pageIterator.next();
                    return true;
                }
                if (this.nextToken.isLast()) {
                    this.alive = false;
                    continue;
                }
                Page page = PaginatedIterable.this.pageFetcher.apply(this.nextToken);
                if (page != null && !page.getNextToken().equals(this.nextToken) && !page.getItems().isEmpty()) {
                    this.nextToken = page.getNextToken();
                    this.pageIterator = page.getItems().iterator();
                    continue;
                }
                this.alive = false;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            Object tmp = this.next;
            this.next = null;
            return tmp;
        }
    }
}

