/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.zeepath;

import java.util.Locale;
import java.util.NoSuchElementException;
import zeenea.connector.commons.zeepath.InvalidZeePathException;
import zeenea.connector.commons.zeepath.ParseStatus;
import zeenea.connector.source.ZeePath;

public class ParsedRef<T> {
    private final ParseStatus status;
    private final ZeePath zeePath;
    private final T result;
    private final InvalidZeePathException exception;

    private ParsedRef(ParseStatus status, ZeePath zeePath, T result, InvalidZeePathException invalidZeePathException) {
        this.status = status;
        this.zeePath = zeePath;
        this.result = result;
        this.exception = invalidZeePathException;
    }

    static <U> ParsedRef<U> supported(ZeePath zeePath, U itemRef) {
        return new ParsedRef<U>(ParseStatus.SUPPORTED, zeePath, itemRef, null);
    }

    static <U> ParsedRef<U> ignored(ZeePath zeePath) {
        return new ParsedRef<Object>(ParseStatus.IGNORED, zeePath, null, null);
    }

    static <U> ParsedRef<U> invalid(ZeePath zeePath, InvalidZeePathException exception) {
        return new ParsedRef<Object>(ParseStatus.INVALID, zeePath, null, exception);
    }

    public boolean isSupported() {
        return this.status == ParseStatus.SUPPORTED;
    }

    public boolean isIgnored() {
        return this.status == ParseStatus.IGNORED;
    }

    public boolean isInvalid() {
        return this.status == ParseStatus.INVALID;
    }

    public ZeePath getZeePath() {
        return this.zeePath;
    }

    public T get() {
        if (this.status != ParseStatus.SUPPORTED) {
            throw new NoSuchElementException("Path " + this.status.toString().toLowerCase(Locale.ROOT));
        }
        return this.result;
    }

    public InvalidZeePathException getException() {
        if (this.status != ParseStatus.INVALID) {
            throw new NoSuchElementException("Path " + this.status.toString().toLowerCase(Locale.ROOT));
        }
        return this.exception;
    }
}

