/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.util.Pair;

public final class RestResponse {
    private final int statusCode;
    @Nullable
    private final List<Pair<String, String>> headers;
    private final byte @Nullable [] body;

    public RestResponse(@NotNull Builder builder) {
        this.statusCode = builder.statusCode;
        this.headers = builder.headers;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Nullable
    public List<Pair<String, String>> headers() {
        return this.headers;
    }

    public byte @Nullable [] body() {
        return this.body;
    }

    public static final class Builder {
        private int statusCode;
        private List<Pair<String, String>> headers;
        private byte[] body;

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder headers(List<Pair<String, String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        public RestResponse build() {
            return new RestResponse(this);
        }
    }
}

