/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.databind.JavaType;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.core5.http.HttpEntity;
import zeenea.connector.commons.http.client.CsvDeserializationException;
import zeenea.connector.commons.http.client.CsvSerealizationException;
import zeenea.connector.commons.http.client.EntityMapper;

public enum HttpCsvMapper implements EntityMapper
{
    INSTANCE;


    public static HttpCsvMapper of() {
        return INSTANCE;
    }

    public List<String[]> readEntity(HttpEntity entity, JavaType type) throws IOException {
        return this.readFromString(new String(entity.getContent().readAllBytes(), StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String[]> readFromString(String csvContent) throws IOException {
        try (StringReader reader = new StringReader(csvContent);){
            List list;
            block13: {
                CSVReader csvReader = new CSVReaderBuilder((Reader)reader).build();
                try {
                    list = csvReader.readAll();
                    if (csvReader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (csvReader != null) {
                        try {
                            csvReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                csvReader.close();
            }
            return list;
        }
        catch (CsvException e) {
            throw new CsvDeserializationException(String.format("Failed parsing CSV response : %s", e.getMessage()), e);
        }
    }

    @Override
    public <T> HttpEntity writeAsEntity(T content) {
        throw new UnsupportedOperationException("Writing CSV data is not supported");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> String prettyPrint(T o) {
        if (!(o instanceof List) || ((List)o).get(0) instanceof String[]) {
            throw new IllegalArgumentException("Input must be a List of String arrays");
        }
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (CSVWriter csvWriter = new CSVWriter((Writer)stringWriter);){
                csvWriter.writeAll((List)o);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new CsvSerealizationException(String.format("Failed parsing csv for printing: %s", e.getMessage()), e);
        }
    }
}

