package zeenea.connector.databricks.unitycatalog.rest.client.model.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.databricks.commons.client.Table;

/**
 * Immutable implementation of {@link Tables}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTables.builder()}.
 */
@Generated(from = "Tables", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTables
    implements Tables {
  private final List<Table> tables;

  private ImmutableTables(List<Table> tables) {
    this.tables = tables;
  }

  /**
   * @return The value of the {@code tables} attribute
   */
  @JsonProperty("tables")
  @Override
  public List<Table> getTables() {
    return tables;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Tables#getTables() tables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTables withTables(Table... elements) {
    List<Table> newValue = List.of(elements);
    return new ImmutableTables(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Tables#getTables() tables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTables withTables(Iterable<? extends Table> elements) {
    if (this.tables == elements) return this;
    List<Table> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Table>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableTables(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTables} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTables
        && equalTo(0, (ImmutableTables) another);
  }

  private boolean equalTo(int synthetic, ImmutableTables another) {
    return tables.equals(another.tables);
  }

  /**
   * Computes a hash code from attributes: {@code tables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Tables} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Tables{"
        + "tables=" + tables
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Tables", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Tables {
    @Nullable List<Table> tables = List.of();
    @JsonProperty("tables")
    public void setTables(List<Table> tables) {
      this.tables = tables;
    }
    @Override
    public List<Table> getTables() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTables fromJson(Json json) {
    ImmutableTables.Builder builder = ImmutableTables.builder();
    if (json.tables != null) {
      builder.addAllTables(json.tables);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Tables} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tables instance
   */
  public static ImmutableTables copyOf(Tables instance) {
    if (instance instanceof ImmutableTables) {
      return (ImmutableTables) instance;
    }
    return ImmutableTables.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTables ImmutableTables}.
   * <pre>
   * ImmutableTables.builder()
   *    .addTables|addAllTables(zeenea.connector.databricks.commons.client.Table) // {@link Tables#getTables() tables} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTables builder
   */
  public static ImmutableTables.Builder builder() {
    return new ImmutableTables.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTables ImmutableTables}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Tables", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Table> tables = new ArrayList<Table>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Tables} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Tables instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTables(instance.getTables());
      return this;
    }

    /**
     * Adds one element to {@link Tables#getTables() tables} list.
     * @param element A tables element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTables(Table element) {
      this.tables.add(Objects.requireNonNull(element, "tables element"));
      return this;
    }

    /**
     * Adds elements to {@link Tables#getTables() tables} list.
     * @param elements An array of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTables(Table... elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Tables#getTables() tables} list.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tables")
    public final Builder tables(Iterable<? extends Table> elements) {
      this.tables.clear();
      return addAllTables(elements);
    }

    /**
     * Adds elements to {@link Tables#getTables() tables} list.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTables(Iterable<? extends Table> elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTables ImmutableTables}.
     * @return An immutable instance of Tables
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTables build() {
      return new ImmutableTables(List.copyOf(tables));
    }
  }
}
