package zeenea.connector.databricks.unitycatalog.rest.client.model.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Schemas}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchemas.builder()}.
 */
@Generated(from = "Schemas", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSchemas
    implements Schemas {
  private final List<Schema> schemas;

  private ImmutableSchemas(List<Schema> schemas) {
    this.schemas = schemas;
  }

  /**
   * @return The value of the {@code schemas} attribute
   */
  @JsonProperty("schemas")
  @Override
  public List<Schema> getSchemas() {
    return schemas;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Schemas#getSchemas() schemas}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchemas withSchemas(Schema... elements) {
    List<Schema> newValue = List.of(elements);
    return new ImmutableSchemas(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Schemas#getSchemas() schemas}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of schemas elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSchemas withSchemas(Iterable<? extends Schema> elements) {
    if (this.schemas == elements) return this;
    List<Schema> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Schema>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSchemas(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchemas} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchemas
        && equalTo(0, (ImmutableSchemas) another);
  }

  private boolean equalTo(int synthetic, ImmutableSchemas another) {
    return schemas.equals(another.schemas);
  }

  /**
   * Computes a hash code from attributes: {@code schemas}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + schemas.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Schemas} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schemas{"
        + "schemas=" + schemas
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Schemas", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Schemas {
    @Nullable List<Schema> schemas = List.of();
    @JsonProperty("schemas")
    public void setSchemas(List<Schema> schemas) {
      this.schemas = schemas;
    }
    @Override
    public List<Schema> getSchemas() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSchemas fromJson(Json json) {
    ImmutableSchemas.Builder builder = ImmutableSchemas.builder();
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Schemas} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Schemas instance
   */
  public static ImmutableSchemas copyOf(Schemas instance) {
    if (instance instanceof ImmutableSchemas) {
      return (ImmutableSchemas) instance;
    }
    return ImmutableSchemas.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchemas ImmutableSchemas}.
   * <pre>
   * ImmutableSchemas.builder()
   *    .addSchemas|addAllSchemas(zeenea.connector.databricks.unitycatalog.rest.client.model.tables.Schema) // {@link Schemas#getSchemas() schemas} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSchemas builder
   */
  public static ImmutableSchemas.Builder builder() {
    return new ImmutableSchemas.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchemas ImmutableSchemas}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Schemas", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Schema> schemas = new ArrayList<Schema>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schemas} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schemas instance) {
      Objects.requireNonNull(instance, "instance");
      addAllSchemas(instance.getSchemas());
      return this;
    }

    /**
     * Adds one element to {@link Schemas#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(Schema element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link Schemas#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(Schema... elements) {
      for (Schema element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Schemas#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<? extends Schema> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link Schemas#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<? extends Schema> elements) {
      for (Schema element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchemas ImmutableSchemas}.
     * @return An immutable instance of Schemas
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchemas build() {
      return new ImmutableSchemas(List.copyOf(schemas));
    }
  }
}
