package zeenea.connector.databricks.unitycatalog.rest.client.model.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Schema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchema.builder()}.
 */
@Generated(from = "Schema", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSchema
    implements Schema {
  private final String name;
  private final String catalogName;

  private ImmutableSchema(String name, String catalogName) {
    this.name = name;
    this.catalogName = catalogName;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code catalogName} attribute
   */
  @JsonProperty("catalog_name")
  @Override
  public String getCatalogName() {
    return catalogName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSchema(newValue, this.catalogName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#getCatalogName() catalogName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalogName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withCatalogName(String value) {
    String newValue = Objects.requireNonNull(value, "catalogName");
    if (this.catalogName.equals(newValue)) return this;
    return new ImmutableSchema(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchema
        && equalTo(0, (ImmutableSchema) another);
  }

  private boolean equalTo(int synthetic, ImmutableSchema another) {
    return name.equals(another.name)
        && catalogName.equals(another.catalogName);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code catalogName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + catalogName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Schema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schema{"
        + "name=" + name
        + ", catalogName=" + catalogName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Schema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Schema {
    @Nullable String name;
    @Nullable String catalogName;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("catalog_name")
    public void setCatalogName(String catalogName) {
      this.catalogName = catalogName;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCatalogName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSchema fromJson(Json json) {
    ImmutableSchema.Builder builder = ImmutableSchema.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.catalogName != null) {
      builder.catalogName(json.catalogName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Schema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Schema instance
   */
  public static ImmutableSchema copyOf(Schema instance) {
    if (instance instanceof ImmutableSchema) {
      return (ImmutableSchema) instance;
    }
    return ImmutableSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchema ImmutableSchema}.
   * <pre>
   * ImmutableSchema.builder()
   *    .name(String) // required {@link Schema#getName() name}
   *    .catalogName(String) // required {@link Schema#getCatalogName() catalogName}
   *    .build();
   * </pre>
   * @return A new ImmutableSchema builder
   */
  public static ImmutableSchema.Builder builder() {
    return new ImmutableSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchema ImmutableSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Schema", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_CATALOG_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String catalogName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schema instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.catalogName(instance.getCatalogName());
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#getCatalogName() catalogName} attribute.
     * @param catalogName The value for catalogName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("catalog_name")
    public final Builder catalogName(String catalogName) {
      this.catalogName = Objects.requireNonNull(catalogName, "catalogName");
      initBits &= ~INIT_BIT_CATALOG_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchema ImmutableSchema}.
     * @return An immutable instance of Schema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchema build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSchema(name, catalogName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CATALOG_NAME) != 0) attributes.add("catalogName");
      return "Cannot build Schema, some of required attributes are not set " + attributes;
    }
  }
}
