package zeenea.connector.databricks.unitycatalog.rest.client.model.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Catalogs}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogs.builder()}.
 */
@Generated(from = "Catalogs", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCatalogs
    implements Catalogs {
  private final List<Catalog> catalogs;

  private ImmutableCatalogs(List<Catalog> catalogs) {
    this.catalogs = catalogs;
  }

  /**
   * @return The value of the {@code catalogs} attribute
   */
  @JsonProperty("catalogs")
  @Override
  public List<Catalog> getCatalogs() {
    return catalogs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Catalogs#getCatalogs() catalogs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogs withCatalogs(Catalog... elements) {
    List<Catalog> newValue = List.of(elements);
    return new ImmutableCatalogs(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Catalogs#getCatalogs() catalogs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of catalogs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogs withCatalogs(Iterable<? extends Catalog> elements) {
    if (this.catalogs == elements) return this;
    List<Catalog> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Catalog>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableCatalogs(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogs} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogs
        && equalTo(0, (ImmutableCatalogs) another);
  }

  private boolean equalTo(int synthetic, ImmutableCatalogs another) {
    return catalogs.equals(another.catalogs);
  }

  /**
   * Computes a hash code from attributes: {@code catalogs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + catalogs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Catalogs} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Catalogs{"
        + "catalogs=" + catalogs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Catalogs", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Catalogs {
    @Nullable List<Catalog> catalogs = List.of();
    @JsonProperty("catalogs")
    public void setCatalogs(List<Catalog> catalogs) {
      this.catalogs = catalogs;
    }
    @Override
    public List<Catalog> getCatalogs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCatalogs fromJson(Json json) {
    ImmutableCatalogs.Builder builder = ImmutableCatalogs.builder();
    if (json.catalogs != null) {
      builder.addAllCatalogs(json.catalogs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Catalogs} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Catalogs instance
   */
  public static ImmutableCatalogs copyOf(Catalogs instance) {
    if (instance instanceof ImmutableCatalogs) {
      return (ImmutableCatalogs) instance;
    }
    return ImmutableCatalogs.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogs ImmutableCatalogs}.
   * <pre>
   * ImmutableCatalogs.builder()
   *    .addCatalogs|addAllCatalogs(zeenea.connector.databricks.unitycatalog.rest.client.model.tables.Catalog) // {@link Catalogs#getCatalogs() catalogs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCatalogs builder
   */
  public static ImmutableCatalogs.Builder builder() {
    return new ImmutableCatalogs.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogs ImmutableCatalogs}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Catalogs", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Catalog> catalogs = new ArrayList<Catalog>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Catalogs} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Catalogs instance) {
      Objects.requireNonNull(instance, "instance");
      addAllCatalogs(instance.getCatalogs());
      return this;
    }

    /**
     * Adds one element to {@link Catalogs#getCatalogs() catalogs} list.
     * @param element A catalogs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCatalogs(Catalog element) {
      this.catalogs.add(Objects.requireNonNull(element, "catalogs element"));
      return this;
    }

    /**
     * Adds elements to {@link Catalogs#getCatalogs() catalogs} list.
     * @param elements An array of catalogs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCatalogs(Catalog... elements) {
      for (Catalog element : elements) {
        this.catalogs.add(Objects.requireNonNull(element, "catalogs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Catalogs#getCatalogs() catalogs} list.
     * @param elements An iterable of catalogs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("catalogs")
    public final Builder catalogs(Iterable<? extends Catalog> elements) {
      this.catalogs.clear();
      return addAllCatalogs(elements);
    }

    /**
     * Adds elements to {@link Catalogs#getCatalogs() catalogs} list.
     * @param elements An iterable of catalogs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCatalogs(Iterable<? extends Catalog> elements) {
      for (Catalog element : elements) {
        this.catalogs.add(Objects.requireNonNull(element, "catalogs element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogs ImmutableCatalogs}.
     * @return An immutable instance of Catalogs
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogs build() {
      return new ImmutableCatalogs(List.copyOf(catalogs));
    }
  }
}
