package zeenea.connector.databricks.unitycatalog.rest.client.model.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Catalog}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalog.builder()}.
 */
@Generated(from = "Catalog", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCatalog
    implements Catalog {
  private final String name;
  private final String catalogType;

  private ImmutableCatalog(String name, String catalogType) {
    this.name = name;
    this.catalogType = catalogType;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code catalogType} attribute
   */
  @JsonProperty("catalog_type")
  @Override
  public String getCatalogType() {
    return catalogType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Catalog#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalog withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCatalog(newValue, this.catalogType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Catalog#getCatalogType() catalogType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalogType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalog withCatalogType(String value) {
    String newValue = Objects.requireNonNull(value, "catalogType");
    if (this.catalogType.equals(newValue)) return this;
    return new ImmutableCatalog(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalog
        && equalTo(0, (ImmutableCatalog) another);
  }

  private boolean equalTo(int synthetic, ImmutableCatalog another) {
    return name.equals(another.name)
        && catalogType.equals(another.catalogType);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code catalogType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + catalogType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Catalog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Catalog{"
        + "name=" + name
        + ", catalogType=" + catalogType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Catalog", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Catalog {
    @Nullable String name;
    @Nullable String catalogType;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("catalog_type")
    public void setCatalogType(String catalogType) {
      this.catalogType = catalogType;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCatalogType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCatalog fromJson(Json json) {
    ImmutableCatalog.Builder builder = ImmutableCatalog.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.catalogType != null) {
      builder.catalogType(json.catalogType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Catalog} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Catalog instance
   */
  public static ImmutableCatalog copyOf(Catalog instance) {
    if (instance instanceof ImmutableCatalog) {
      return (ImmutableCatalog) instance;
    }
    return ImmutableCatalog.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalog ImmutableCatalog}.
   * <pre>
   * ImmutableCatalog.builder()
   *    .name(String) // required {@link Catalog#getName() name}
   *    .catalogType(String) // required {@link Catalog#getCatalogType() catalogType}
   *    .build();
   * </pre>
   * @return A new ImmutableCatalog builder
   */
  public static ImmutableCatalog.Builder builder() {
    return new ImmutableCatalog.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalog ImmutableCatalog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Catalog", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_CATALOG_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String catalogType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Catalog} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Catalog instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.catalogType(instance.getCatalogType());
      return this;
    }

    /**
     * Initializes the value for the {@link Catalog#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Catalog#getCatalogType() catalogType} attribute.
     * @param catalogType The value for catalogType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("catalog_type")
    public final Builder catalogType(String catalogType) {
      this.catalogType = Objects.requireNonNull(catalogType, "catalogType");
      initBits &= ~INIT_BIT_CATALOG_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalog ImmutableCatalog}.
     * @return An immutable instance of Catalog
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalog build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalog(name, catalogType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CATALOG_TYPE) != 0) attributes.add("catalogType");
      return "Cannot build Catalog, some of required attributes are not set " + attributes;
    }
  }
}
