package zeenea.connector.databricks.unitycatalog.rest.client.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.databricks.commons.client.Table;

/**
 * Immutable implementation of {@link LineageStream}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLineageStream.builder()}.
 */
@Generated(from = "LineageStream", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableLineageStream
    implements LineageStream {
  private final @Nullable Table tableInfo;
  private final @Nullable List<JobInfo> jobInfos;

  private ImmutableLineageStream(
      @Nullable Table tableInfo,
      @Nullable List<JobInfo> jobInfos) {
    this.tableInfo = tableInfo;
    this.jobInfos = jobInfos;
  }

  /**
   * @return The value of the {@code tableInfo} attribute
   */
  @JsonProperty("tableInfo")
  @Override
  public @Nullable Table getTableInfo() {
    return tableInfo;
  }

  /**
   * @return The value of the {@code jobInfos} attribute
   */
  @JsonProperty("jobInfos")
  @Override
  public @Nullable List<JobInfo> getJobInfos() {
    return jobInfos;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LineageStream#getTableInfo() tableInfo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableInfo (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLineageStream withTableInfo(@Nullable Table value) {
    if (this.tableInfo == value) return this;
    return new ImmutableLineageStream(value, this.jobInfos);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LineageStream#getJobInfos() jobInfos}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLineageStream withJobInfos(@Nullable JobInfo... elements) {
    if (elements == null) {
      return new ImmutableLineageStream(this.tableInfo, null);
    }
    List<JobInfo> newValue = List.of(elements);
    return new ImmutableLineageStream(this.tableInfo, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LineageStream#getJobInfos() jobInfos}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of jobInfos elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLineageStream withJobInfos(@Nullable Iterable<? extends JobInfo> elements) {
    if (this.jobInfos == elements) return this;
    @Nullable List<JobInfo> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends JobInfo>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableLineageStream(this.tableInfo, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLineageStream} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLineageStream
        && equalTo(0, (ImmutableLineageStream) another);
  }

  private boolean equalTo(int synthetic, ImmutableLineageStream another) {
    return Objects.equals(tableInfo, another.tableInfo)
        && Objects.equals(jobInfos, another.jobInfos);
  }

  /**
   * Computes a hash code from attributes: {@code tableInfo}, {@code jobInfos}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tableInfo);
    h += (h << 5) + Objects.hashCode(jobInfos);
    return h;
  }

  /**
   * Prints the immutable value {@code LineageStream} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LineageStream{"
        + "tableInfo=" + tableInfo
        + ", jobInfos=" + jobInfos
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LineageStream", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements LineageStream {
    @javax.annotation.Nullable Table tableInfo;
    @javax.annotation.Nullable List<JobInfo> jobInfos = null;
    @JsonProperty("tableInfo")
    public void setTableInfo(@Nullable Table tableInfo) {
      this.tableInfo = tableInfo;
    }
    @JsonProperty("jobInfos")
    public void setJobInfos(@Nullable List<JobInfo> jobInfos) {
      this.jobInfos = jobInfos;
    }
    @Override
    public Table getTableInfo() { throw new UnsupportedOperationException(); }
    @Override
    public List<JobInfo> getJobInfos() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLineageStream fromJson(Json json) {
    ImmutableLineageStream.Builder builder = ImmutableLineageStream.builder();
    if (json.tableInfo != null) {
      builder.tableInfo(json.tableInfo);
    }
    if (json.jobInfos != null) {
      builder.addAllJobInfos(json.jobInfos);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LineageStream} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LineageStream instance
   */
  public static ImmutableLineageStream copyOf(LineageStream instance) {
    if (instance instanceof ImmutableLineageStream) {
      return (ImmutableLineageStream) instance;
    }
    return ImmutableLineageStream.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLineageStream ImmutableLineageStream}.
   * <pre>
   * ImmutableLineageStream.builder()
   *    .tableInfo(zeenea.connector.databricks.commons.client.Table | null) // nullable {@link LineageStream#getTableInfo() tableInfo}
   *    .jobInfos(List&amp;lt;zeenea.connector.databricks.unitycatalog.rest.client.model.lineage.JobInfo&amp;gt; | null) // nullable {@link LineageStream#getJobInfos() jobInfos}
   *    .build();
   * </pre>
   * @return A new ImmutableLineageStream builder
   */
  public static ImmutableLineageStream.Builder builder() {
    return new ImmutableLineageStream.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLineageStream ImmutableLineageStream}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LineageStream", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable Table tableInfo;
    private List<JobInfo> jobInfos = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LineageStream} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LineageStream instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Table tableInfoValue = instance.getTableInfo();
      if (tableInfoValue != null) {
        tableInfo(tableInfoValue);
      }
      @Nullable List<JobInfo> jobInfosValue = instance.getJobInfos();
      if (jobInfosValue != null) {
        addAllJobInfos(jobInfosValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LineageStream#getTableInfo() tableInfo} attribute.
     * @param tableInfo The value for tableInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tableInfo")
    public final Builder tableInfo(@Nullable Table tableInfo) {
      this.tableInfo = tableInfo;
      return this;
    }

    /**
     * Adds one element to {@link LineageStream#getJobInfos() jobInfos} list.
     * @param element A jobInfos element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJobInfos(JobInfo element) {
      if (this.jobInfos == null) {
        this.jobInfos = new ArrayList<JobInfo>();
      }
      this.jobInfos.add(Objects.requireNonNull(element, "jobInfos element"));
      return this;
    }

    /**
     * Adds elements to {@link LineageStream#getJobInfos() jobInfos} list.
     * @param elements An array of jobInfos elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJobInfos(JobInfo... elements) {
      if (this.jobInfos == null) {
        this.jobInfos = new ArrayList<JobInfo>();
      }
      for (JobInfo element : elements) {
        this.jobInfos.add(Objects.requireNonNull(element, "jobInfos element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LineageStream#getJobInfos() jobInfos} list.
     * @param elements An iterable of jobInfos elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jobInfos")
    public final Builder jobInfos(@Nullable Iterable<? extends JobInfo> elements) {
      if (elements == null) {
        this.jobInfos = null;
        return this;
      }
      this.jobInfos = new ArrayList<JobInfo>();
      return addAllJobInfos(elements);
    }

    /**
     * Adds elements to {@link LineageStream#getJobInfos() jobInfos} list.
     * @param elements An iterable of jobInfos elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJobInfos(Iterable<? extends JobInfo> elements) {
      Objects.requireNonNull(elements, "jobInfos element");
      if (this.jobInfos == null) {
        this.jobInfos = new ArrayList<JobInfo>();
      }
      for (JobInfo element : elements) {
        this.jobInfos.add(Objects.requireNonNull(element, "jobInfos element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableLineageStream ImmutableLineageStream}.
     * @return An immutable instance of LineageStream
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLineageStream build() {
      return new ImmutableLineageStream(tableInfo, jobInfos == null ? null : List.copyOf(jobInfos));
    }
  }
}
