package zeenea.connector.databricks.unitycatalog.rest.client.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JobInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobInfo.builder()}.
 */
@Generated(from = "JobInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableJobInfo
    implements JobInfo {
  private final String workspaceId;
  private final String jobId;

  private ImmutableJobInfo(String workspaceId, String jobId) {
    this.workspaceId = workspaceId;
    this.jobId = jobId;
  }

  /**
   * @return The value of the {@code workspaceId} attribute
   */
  @JsonProperty("workspace_id")
  @Override
  public String getWorkspaceId() {
    return workspaceId;
  }

  /**
   * @return The value of the {@code jobId} attribute
   */
  @JsonProperty("job_id")
  @Override
  public String getJobId() {
    return jobId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfo#getWorkspaceId() workspaceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workspaceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfo withWorkspaceId(String value) {
    String newValue = Objects.requireNonNull(value, "workspaceId");
    if (this.workspaceId.equals(newValue)) return this;
    return new ImmutableJobInfo(newValue, this.jobId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfo#getJobId() jobId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfo withJobId(String value) {
    String newValue = Objects.requireNonNull(value, "jobId");
    if (this.jobId.equals(newValue)) return this;
    return new ImmutableJobInfo(this.workspaceId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobInfo
        && equalTo(0, (ImmutableJobInfo) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobInfo another) {
    return workspaceId.equals(another.workspaceId)
        && jobId.equals(another.jobId);
  }

  /**
   * Computes a hash code from attributes: {@code workspaceId}, {@code jobId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + workspaceId.hashCode();
    h += (h << 5) + jobId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JobInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobInfo{"
        + "workspaceId=" + workspaceId
        + ", jobId=" + jobId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JobInfo", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements JobInfo {
    @Nullable String workspaceId;
    @Nullable String jobId;
    @JsonProperty("workspace_id")
    public void setWorkspaceId(String workspaceId) {
      this.workspaceId = workspaceId;
    }
    @JsonProperty("job_id")
    public void setJobId(String jobId) {
      this.jobId = jobId;
    }
    @Override
    public String getWorkspaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getJobId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJobInfo fromJson(Json json) {
    ImmutableJobInfo.Builder builder = ImmutableJobInfo.builder();
    if (json.workspaceId != null) {
      builder.workspaceId(json.workspaceId);
    }
    if (json.jobId != null) {
      builder.jobId(json.jobId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JobInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobInfo instance
   */
  public static ImmutableJobInfo copyOf(JobInfo instance) {
    if (instance instanceof ImmutableJobInfo) {
      return (ImmutableJobInfo) instance;
    }
    return ImmutableJobInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobInfo ImmutableJobInfo}.
   * <pre>
   * ImmutableJobInfo.builder()
   *    .workspaceId(String) // required {@link JobInfo#getWorkspaceId() workspaceId}
   *    .jobId(String) // required {@link JobInfo#getJobId() jobId}
   *    .build();
   * </pre>
   * @return A new ImmutableJobInfo builder
   */
  public static ImmutableJobInfo.Builder builder() {
    return new ImmutableJobInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobInfo ImmutableJobInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JobInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKSPACE_ID = 0x1L;
    private static final long INIT_BIT_JOB_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String workspaceId;
    private @Nullable String jobId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobInfo instance) {
      Objects.requireNonNull(instance, "instance");
      this.workspaceId(instance.getWorkspaceId());
      this.jobId(instance.getJobId());
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfo#getWorkspaceId() workspaceId} attribute.
     * @param workspaceId The value for workspaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("workspace_id")
    public final Builder workspaceId(String workspaceId) {
      this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId");
      initBits &= ~INIT_BIT_WORKSPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfo#getJobId() jobId} attribute.
     * @param jobId The value for jobId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("job_id")
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      initBits &= ~INIT_BIT_JOB_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobInfo ImmutableJobInfo}.
     * @return An immutable instance of JobInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJobInfo(workspaceId, jobId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKSPACE_ID) != 0) attributes.add("workspaceId");
      if ((initBits & INIT_BIT_JOB_ID) != 0) attributes.add("jobId");
      return "Cannot build JobInfo, some of required attributes are not set " + attributes;
    }
  }
}
