package zeenea.connector.databricks.unitycatalog.rest.client.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.databricks.commons.client.Table;

/**
 * Immutable implementation of {@link Job}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJob.builder()}.
 */
@Generated(from = "Job", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableJob
    implements Job {
  private final String jobId;
  private final JobSettings settings;
  private final String creatorName;
  private final String createdTime;
  private final List<Table> inputs;
  private final List<Table> outputs;

  private ImmutableJob(
      String jobId,
      JobSettings settings,
      String creatorName,
      String createdTime,
      List<Table> inputs,
      List<Table> outputs) {
    this.jobId = jobId;
    this.settings = settings;
    this.creatorName = creatorName;
    this.createdTime = createdTime;
    this.inputs = inputs;
    this.outputs = outputs;
  }

  /**
   * @return The value of the {@code jobId} attribute
   */
  @JsonProperty("job_id")
  @Override
  public String getJobId() {
    return jobId;
  }

  /**
   * @return The value of the {@code settings} attribute
   */
  @JsonProperty("settings")
  @Override
  public JobSettings getSettings() {
    return settings;
  }

  /**
   * @return The value of the {@code creatorName} attribute
   */
  @JsonProperty("creator_user_name")
  @Override
  public String getCreatorName() {
    return creatorName;
  }

  /**
   * @return The value of the {@code createdTime} attribute
   */
  @JsonProperty("created_time")
  @Override
  public String getCreatedTime() {
    return createdTime;
  }

  /**
   * @return The value of the {@code inputs} attribute
   */
  @JsonProperty("inputs")
  @Override
  public List<Table> getInputs() {
    return inputs;
  }

  /**
   * @return The value of the {@code outputs} attribute
   */
  @JsonProperty("outputs")
  @Override
  public List<Table> getOutputs() {
    return outputs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Job#getJobId() jobId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJob withJobId(String value) {
    String newValue = Objects.requireNonNull(value, "jobId");
    if (this.jobId.equals(newValue)) return this;
    return new ImmutableJob(newValue, this.settings, this.creatorName, this.createdTime, this.inputs, this.outputs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Job#getSettings() settings} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for settings
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJob withSettings(JobSettings value) {
    if (this.settings == value) return this;
    JobSettings newValue = Objects.requireNonNull(value, "settings");
    return new ImmutableJob(this.jobId, newValue, this.creatorName, this.createdTime, this.inputs, this.outputs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Job#getCreatorName() creatorName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creatorName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJob withCreatorName(String value) {
    String newValue = Objects.requireNonNull(value, "creatorName");
    if (this.creatorName.equals(newValue)) return this;
    return new ImmutableJob(this.jobId, this.settings, newValue, this.createdTime, this.inputs, this.outputs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Job#getCreatedTime() createdTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJob withCreatedTime(String value) {
    String newValue = Objects.requireNonNull(value, "createdTime");
    if (this.createdTime.equals(newValue)) return this;
    return new ImmutableJob(this.jobId, this.settings, this.creatorName, newValue, this.inputs, this.outputs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Job#getInputs() inputs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJob withInputs(Table... elements) {
    List<Table> newValue = List.of(elements);
    return new ImmutableJob(this.jobId, this.settings, this.creatorName, this.createdTime, newValue, this.outputs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Job#getInputs() inputs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of inputs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJob withInputs(Iterable<? extends Table> elements) {
    if (this.inputs == elements) return this;
    List<Table> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Table>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableJob(this.jobId, this.settings, this.creatorName, this.createdTime, newValue, this.outputs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Job#getOutputs() outputs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJob withOutputs(Table... elements) {
    List<Table> newValue = List.of(elements);
    return new ImmutableJob(this.jobId, this.settings, this.creatorName, this.createdTime, this.inputs, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Job#getOutputs() outputs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of outputs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJob withOutputs(Iterable<? extends Table> elements) {
    if (this.outputs == elements) return this;
    List<Table> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Table>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableJob(this.jobId, this.settings, this.creatorName, this.createdTime, this.inputs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJob
        && equalTo(0, (ImmutableJob) another);
  }

  private boolean equalTo(int synthetic, ImmutableJob another) {
    return jobId.equals(another.jobId)
        && settings.equals(another.settings)
        && creatorName.equals(another.creatorName)
        && createdTime.equals(another.createdTime)
        && inputs.equals(another.inputs)
        && outputs.equals(another.outputs);
  }

  /**
   * Computes a hash code from attributes: {@code jobId}, {@code settings}, {@code creatorName}, {@code createdTime}, {@code inputs}, {@code outputs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + jobId.hashCode();
    h += (h << 5) + settings.hashCode();
    h += (h << 5) + creatorName.hashCode();
    h += (h << 5) + createdTime.hashCode();
    h += (h << 5) + inputs.hashCode();
    h += (h << 5) + outputs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Job} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Job{"
        + "jobId=" + jobId
        + ", settings=" + settings
        + ", creatorName=" + creatorName
        + ", createdTime=" + createdTime
        + ", inputs=" + inputs
        + ", outputs=" + outputs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Job", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Job {
    @Nullable String jobId;
    @Nullable JobSettings settings;
    @Nullable String creatorName;
    @Nullable String createdTime;
    @Nullable List<Table> inputs = List.of();
    @Nullable List<Table> outputs = List.of();
    @JsonProperty("job_id")
    public void setJobId(String jobId) {
      this.jobId = jobId;
    }
    @JsonProperty("settings")
    public void setSettings(JobSettings settings) {
      this.settings = settings;
    }
    @JsonProperty("creator_user_name")
    public void setCreatorName(String creatorName) {
      this.creatorName = creatorName;
    }
    @JsonProperty("created_time")
    public void setCreatedTime(String createdTime) {
      this.createdTime = createdTime;
    }
    @JsonProperty("inputs")
    public void setInputs(List<Table> inputs) {
      this.inputs = inputs;
    }
    @JsonProperty("outputs")
    public void setOutputs(List<Table> outputs) {
      this.outputs = outputs;
    }
    @Override
    public String getJobId() { throw new UnsupportedOperationException(); }
    @Override
    public JobSettings getSettings() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatorName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedTime() { throw new UnsupportedOperationException(); }
    @Override
    public List<Table> getInputs() { throw new UnsupportedOperationException(); }
    @Override
    public List<Table> getOutputs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJob fromJson(Json json) {
    ImmutableJob.Builder builder = ImmutableJob.builder();
    if (json.jobId != null) {
      builder.jobId(json.jobId);
    }
    if (json.settings != null) {
      builder.settings(json.settings);
    }
    if (json.creatorName != null) {
      builder.creatorName(json.creatorName);
    }
    if (json.createdTime != null) {
      builder.createdTime(json.createdTime);
    }
    if (json.inputs != null) {
      builder.addAllInputs(json.inputs);
    }
    if (json.outputs != null) {
      builder.addAllOutputs(json.outputs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Job} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Job instance
   */
  public static ImmutableJob copyOf(Job instance) {
    if (instance instanceof ImmutableJob) {
      return (ImmutableJob) instance;
    }
    return ImmutableJob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJob ImmutableJob}.
   * <pre>
   * ImmutableJob.builder()
   *    .jobId(String) // required {@link Job#getJobId() jobId}
   *    .settings(zeenea.connector.databricks.unitycatalog.rest.client.model.lineage.JobSettings) // required {@link Job#getSettings() settings}
   *    .creatorName(String) // required {@link Job#getCreatorName() creatorName}
   *    .createdTime(String) // required {@link Job#getCreatedTime() createdTime}
   *    .addInputs|addAllInputs(zeenea.connector.databricks.commons.client.Table) // {@link Job#getInputs() inputs} elements
   *    .addOutputs|addAllOutputs(zeenea.connector.databricks.commons.client.Table) // {@link Job#getOutputs() outputs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJob builder
   */
  public static ImmutableJob.Builder builder() {
    return new ImmutableJob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJob ImmutableJob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Job", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_JOB_ID = 0x1L;
    private static final long INIT_BIT_SETTINGS = 0x2L;
    private static final long INIT_BIT_CREATOR_NAME = 0x4L;
    private static final long INIT_BIT_CREATED_TIME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String jobId;
    private @Nullable JobSettings settings;
    private @Nullable String creatorName;
    private @Nullable String createdTime;
    private List<Table> inputs = new ArrayList<Table>();
    private List<Table> outputs = new ArrayList<Table>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Job} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Job instance) {
      Objects.requireNonNull(instance, "instance");
      this.jobId(instance.getJobId());
      this.settings(instance.getSettings());
      this.creatorName(instance.getCreatorName());
      this.createdTime(instance.getCreatedTime());
      addAllInputs(instance.getInputs());
      addAllOutputs(instance.getOutputs());
      return this;
    }

    /**
     * Initializes the value for the {@link Job#getJobId() jobId} attribute.
     * @param jobId The value for jobId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("job_id")
    public final Builder jobId(String jobId) {
      this.jobId = Objects.requireNonNull(jobId, "jobId");
      initBits &= ~INIT_BIT_JOB_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Job#getSettings() settings} attribute.
     * @param settings The value for settings 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("settings")
    public final Builder settings(JobSettings settings) {
      this.settings = Objects.requireNonNull(settings, "settings");
      initBits &= ~INIT_BIT_SETTINGS;
      return this;
    }

    /**
     * Initializes the value for the {@link Job#getCreatorName() creatorName} attribute.
     * @param creatorName The value for creatorName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("creator_user_name")
    public final Builder creatorName(String creatorName) {
      this.creatorName = Objects.requireNonNull(creatorName, "creatorName");
      initBits &= ~INIT_BIT_CREATOR_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Job#getCreatedTime() createdTime} attribute.
     * @param createdTime The value for createdTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_time")
    public final Builder createdTime(String createdTime) {
      this.createdTime = Objects.requireNonNull(createdTime, "createdTime");
      initBits &= ~INIT_BIT_CREATED_TIME;
      return this;
    }

    /**
     * Adds one element to {@link Job#getInputs() inputs} list.
     * @param element A inputs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputs(Table element) {
      this.inputs.add(Objects.requireNonNull(element, "inputs element"));
      return this;
    }

    /**
     * Adds elements to {@link Job#getInputs() inputs} list.
     * @param elements An array of inputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInputs(Table... elements) {
      for (Table element : elements) {
        this.inputs.add(Objects.requireNonNull(element, "inputs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Job#getInputs() inputs} list.
     * @param elements An iterable of inputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("inputs")
    public final Builder inputs(Iterable<? extends Table> elements) {
      this.inputs.clear();
      return addAllInputs(elements);
    }

    /**
     * Adds elements to {@link Job#getInputs() inputs} list.
     * @param elements An iterable of inputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInputs(Iterable<? extends Table> elements) {
      for (Table element : elements) {
        this.inputs.add(Objects.requireNonNull(element, "inputs element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Job#getOutputs() outputs} list.
     * @param element A outputs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOutputs(Table element) {
      this.outputs.add(Objects.requireNonNull(element, "outputs element"));
      return this;
    }

    /**
     * Adds elements to {@link Job#getOutputs() outputs} list.
     * @param elements An array of outputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOutputs(Table... elements) {
      for (Table element : elements) {
        this.outputs.add(Objects.requireNonNull(element, "outputs element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Job#getOutputs() outputs} list.
     * @param elements An iterable of outputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("outputs")
    public final Builder outputs(Iterable<? extends Table> elements) {
      this.outputs.clear();
      return addAllOutputs(elements);
    }

    /**
     * Adds elements to {@link Job#getOutputs() outputs} list.
     * @param elements An iterable of outputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOutputs(Iterable<? extends Table> elements) {
      for (Table element : elements) {
        this.outputs.add(Objects.requireNonNull(element, "outputs element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableJob ImmutableJob}.
     * @return An immutable instance of Job
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJob build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJob(
          jobId,
          settings,
          creatorName,
          createdTime,
          List.copyOf(inputs),
          List.copyOf(outputs));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_JOB_ID) != 0) attributes.add("jobId");
      if ((initBits & INIT_BIT_SETTINGS) != 0) attributes.add("settings");
      if ((initBits & INIT_BIT_CREATOR_NAME) != 0) attributes.add("creatorName");
      if ((initBits & INIT_BIT_CREATED_TIME) != 0) attributes.add("createdTime");
      return "Cannot build Job, some of required attributes are not set " + attributes;
    }
  }
}
