package zeenea.connector.databricks.unitycatalog.rest.client.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ColumnLineage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumnLineage.builder()}.
 */
@Generated(from = "ColumnLineage", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableColumnLineage
    implements ColumnLineage {
  private final List<Column> upstreamColumns;
  private final List<Column> downstreamColumns;

  private ImmutableColumnLineage(
      List<Column> upstreamColumns,
      List<Column> downstreamColumns) {
    this.upstreamColumns = upstreamColumns;
    this.downstreamColumns = downstreamColumns;
  }

  /**
   * @return The value of the {@code upstreamColumns} attribute
   */
  @JsonProperty("upstream_cols")
  @Override
  public List<Column> getUpstreamColumns() {
    return upstreamColumns;
  }

  /**
   * @return The value of the {@code downstreamColumns} attribute
   */
  @JsonProperty("downstream_cols")
  @Override
  public List<Column> getDownstreamColumns() {
    return downstreamColumns;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ColumnLineage#getUpstreamColumns() upstreamColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnLineage withUpstreamColumns(Column... elements) {
    List<Column> newValue = List.of(elements);
    return new ImmutableColumnLineage(newValue, this.downstreamColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ColumnLineage#getUpstreamColumns() upstreamColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of upstreamColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnLineage withUpstreamColumns(Iterable<? extends Column> elements) {
    if (this.upstreamColumns == elements) return this;
    List<Column> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Column>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableColumnLineage(newValue, this.downstreamColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ColumnLineage#getDownstreamColumns() downstreamColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnLineage withDownstreamColumns(Column... elements) {
    List<Column> newValue = List.of(elements);
    return new ImmutableColumnLineage(this.upstreamColumns, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ColumnLineage#getDownstreamColumns() downstreamColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of downstreamColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableColumnLineage withDownstreamColumns(Iterable<? extends Column> elements) {
    if (this.downstreamColumns == elements) return this;
    List<Column> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Column>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableColumnLineage(this.upstreamColumns, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumnLineage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumnLineage
        && equalTo(0, (ImmutableColumnLineage) another);
  }

  private boolean equalTo(int synthetic, ImmutableColumnLineage another) {
    return upstreamColumns.equals(another.upstreamColumns)
        && downstreamColumns.equals(another.downstreamColumns);
  }

  /**
   * Computes a hash code from attributes: {@code upstreamColumns}, {@code downstreamColumns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + upstreamColumns.hashCode();
    h += (h << 5) + downstreamColumns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ColumnLineage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ColumnLineage{"
        + "upstreamColumns=" + upstreamColumns
        + ", downstreamColumns=" + downstreamColumns
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ColumnLineage", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ColumnLineage {
    @Nullable List<Column> upstreamColumns = List.of();
    @Nullable List<Column> downstreamColumns = List.of();
    @JsonProperty("upstream_cols")
    public void setUpstreamColumns(List<Column> upstreamColumns) {
      this.upstreamColumns = upstreamColumns;
    }
    @JsonProperty("downstream_cols")
    public void setDownstreamColumns(List<Column> downstreamColumns) {
      this.downstreamColumns = downstreamColumns;
    }
    @Override
    public List<Column> getUpstreamColumns() { throw new UnsupportedOperationException(); }
    @Override
    public List<Column> getDownstreamColumns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableColumnLineage fromJson(Json json) {
    ImmutableColumnLineage.Builder builder = ImmutableColumnLineage.builder();
    if (json.upstreamColumns != null) {
      builder.addAllUpstreamColumns(json.upstreamColumns);
    }
    if (json.downstreamColumns != null) {
      builder.addAllDownstreamColumns(json.downstreamColumns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ColumnLineage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ColumnLineage instance
   */
  public static ImmutableColumnLineage copyOf(ColumnLineage instance) {
    if (instance instanceof ImmutableColumnLineage) {
      return (ImmutableColumnLineage) instance;
    }
    return ImmutableColumnLineage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumnLineage ImmutableColumnLineage}.
   * <pre>
   * ImmutableColumnLineage.builder()
   *    .addUpstreamColumns|addAllUpstreamColumns(zeenea.connector.databricks.unitycatalog.rest.client.model.lineage.Column) // {@link ColumnLineage#getUpstreamColumns() upstreamColumns} elements
   *    .addDownstreamColumns|addAllDownstreamColumns(zeenea.connector.databricks.unitycatalog.rest.client.model.lineage.Column) // {@link ColumnLineage#getDownstreamColumns() downstreamColumns} elements
   *    .build();
   * </pre>
   * @return A new ImmutableColumnLineage builder
   */
  public static ImmutableColumnLineage.Builder builder() {
    return new ImmutableColumnLineage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumnLineage ImmutableColumnLineage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ColumnLineage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<Column> upstreamColumns = new ArrayList<Column>();
    private List<Column> downstreamColumns = new ArrayList<Column>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ColumnLineage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ColumnLineage instance) {
      Objects.requireNonNull(instance, "instance");
      addAllUpstreamColumns(instance.getUpstreamColumns());
      addAllDownstreamColumns(instance.getDownstreamColumns());
      return this;
    }

    /**
     * Adds one element to {@link ColumnLineage#getUpstreamColumns() upstreamColumns} list.
     * @param element A upstreamColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUpstreamColumns(Column element) {
      this.upstreamColumns.add(Objects.requireNonNull(element, "upstreamColumns element"));
      return this;
    }

    /**
     * Adds elements to {@link ColumnLineage#getUpstreamColumns() upstreamColumns} list.
     * @param elements An array of upstreamColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUpstreamColumns(Column... elements) {
      for (Column element : elements) {
        this.upstreamColumns.add(Objects.requireNonNull(element, "upstreamColumns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ColumnLineage#getUpstreamColumns() upstreamColumns} list.
     * @param elements An iterable of upstreamColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("upstream_cols")
    public final Builder upstreamColumns(Iterable<? extends Column> elements) {
      this.upstreamColumns.clear();
      return addAllUpstreamColumns(elements);
    }

    /**
     * Adds elements to {@link ColumnLineage#getUpstreamColumns() upstreamColumns} list.
     * @param elements An iterable of upstreamColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUpstreamColumns(Iterable<? extends Column> elements) {
      for (Column element : elements) {
        this.upstreamColumns.add(Objects.requireNonNull(element, "upstreamColumns element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ColumnLineage#getDownstreamColumns() downstreamColumns} list.
     * @param element A downstreamColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDownstreamColumns(Column element) {
      this.downstreamColumns.add(Objects.requireNonNull(element, "downstreamColumns element"));
      return this;
    }

    /**
     * Adds elements to {@link ColumnLineage#getDownstreamColumns() downstreamColumns} list.
     * @param elements An array of downstreamColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDownstreamColumns(Column... elements) {
      for (Column element : elements) {
        this.downstreamColumns.add(Objects.requireNonNull(element, "downstreamColumns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ColumnLineage#getDownstreamColumns() downstreamColumns} list.
     * @param elements An iterable of downstreamColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("downstream_cols")
    public final Builder downstreamColumns(Iterable<? extends Column> elements) {
      this.downstreamColumns.clear();
      return addAllDownstreamColumns(elements);
    }

    /**
     * Adds elements to {@link ColumnLineage#getDownstreamColumns() downstreamColumns} list.
     * @param elements An iterable of downstreamColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDownstreamColumns(Iterable<? extends Column> elements) {
      for (Column element : elements) {
        this.downstreamColumns.add(Objects.requireNonNull(element, "downstreamColumns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumnLineage ImmutableColumnLineage}.
     * @return An immutable instance of ColumnLineage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumnLineage build() {
      return new ImmutableColumnLineage(List.copyOf(upstreamColumns), List.copyOf(downstreamColumns));
    }
  }
}
