package zeenea.connector.databricks.unitycatalog.rest.client.model.fields;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link StructField}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStructField.builder()}.
 */
@Generated(from = "StructField", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableStructField
    implements StructField {
  private final String name;
  private final @Nullable String comment;
  private final @Nullable FieldType type;
  private final boolean nullable;

  private ImmutableStructField(
      String name,
      @Nullable String comment,
      @Nullable FieldType type,
      boolean nullable) {
    this.name = name;
    this.comment = comment;
    this.type = type;
    this.nullable = nullable;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("comment")
  @Override
  public @Nullable String getComment() {
    return comment;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable FieldType getType() {
    return type;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @Override
  public boolean isNullable() {
    return nullable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StructField#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStructField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableStructField(newValue, this.comment, this.type, this.nullable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StructField#getComment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStructField withComment(@Nullable String value) {
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableStructField(this.name, value, this.type, this.nullable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StructField#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStructField withType(@Nullable FieldType value) {
    if (this.type == value) return this;
    return new ImmutableStructField(this.name, this.comment, value, this.nullable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StructField#isNullable() nullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStructField withNullable(boolean value) {
    if (this.nullable == value) return this;
    return new ImmutableStructField(this.name, this.comment, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStructField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStructField
        && equalTo(0, (ImmutableStructField) another);
  }

  private boolean equalTo(int synthetic, ImmutableStructField another) {
    return name.equals(another.name)
        && Objects.equals(comment, another.comment)
        && Objects.equals(type, another.type)
        && nullable == another.nullable;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code comment}, {@code type}, {@code nullable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Boolean.hashCode(nullable);
    return h;
  }

  /**
   * Prints the immutable value {@code StructField} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StructField{"
        + "name=" + name
        + ", comment=" + comment
        + ", type=" + type
        + ", nullable=" + nullable
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StructField", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements StructField {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String comment;
    @javax.annotation.Nullable FieldType type;
    boolean nullable;
    boolean nullableIsSet;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("comment")
    public void setComment(@Nullable String comment) {
      this.comment = comment;
    }
    @JsonProperty("type")
    public void setType(@Nullable FieldType type) {
      this.type = type;
    }
    @JsonProperty("nullable")
    public void setNullable(boolean nullable) {
      this.nullable = nullable;
      this.nullableIsSet = true;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getComment() { throw new UnsupportedOperationException(); }
    @Override
    public FieldType getType() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isNullable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStructField fromJson(Json json) {
    ImmutableStructField.Builder builder = ImmutableStructField.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.nullableIsSet) {
      builder.nullable(json.nullable);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StructField} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StructField instance
   */
  public static ImmutableStructField copyOf(StructField instance) {
    if (instance instanceof ImmutableStructField) {
      return (ImmutableStructField) instance;
    }
    return ImmutableStructField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStructField ImmutableStructField}.
   * <pre>
   * ImmutableStructField.builder()
   *    .name(String) // required {@link StructField#getName() name}
   *    .comment(String | null) // nullable {@link StructField#getComment() comment}
   *    .type(zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType | null) // nullable {@link StructField#getType() type}
   *    .nullable(boolean) // required {@link StructField#isNullable() nullable}
   *    .build();
   * </pre>
   * @return A new ImmutableStructField builder
   */
  public static ImmutableStructField.Builder builder() {
    return new ImmutableStructField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStructField ImmutableStructField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StructField", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_NULLABLE = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String comment;
    private @javax.annotation.Nullable FieldType type;
    private boolean nullable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StructField} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StructField instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      @Nullable String commentValue = instance.getComment();
      if (commentValue != null) {
        comment(commentValue);
      }
      @Nullable FieldType typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      this.nullable(instance.isNullable());
      return this;
    }

    /**
     * Initializes the value for the {@link StructField#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StructField#getComment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("comment")
    public final Builder comment(@Nullable String comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Initializes the value for the {@link StructField#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable FieldType type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link StructField#isNullable() nullable} attribute.
     * @param nullable The value for nullable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nullable")
    public final Builder nullable(boolean nullable) {
      this.nullable = nullable;
      initBits &= ~INIT_BIT_NULLABLE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStructField ImmutableStructField}.
     * @return An immutable instance of StructField
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStructField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStructField(name, comment, type, nullable);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NULLABLE) != 0) attributes.add("nullable");
      return "Cannot build StructField, some of required attributes are not set " + attributes;
    }
  }
}
