package zeenea.connector.databricks.unitycatalog.rest.client.model.fields;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link FieldType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldType.builder()}.
 */
@Generated(from = "FieldType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFieldType
    implements FieldType {
  private final String type;
  private final String nativeType;
  private final @Nullable String description;

  private ImmutableFieldType(
      String type,
      String nativeType,
      @Nullable String description) {
    this.type = type;
    this.nativeType = nativeType;
    this.description = description;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code nativeType} attribute
   */
  @JsonProperty("nativeType")
  @Override
  public String getNativeType() {
    return nativeType;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldType#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldType withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFieldType(newValue, this.nativeType, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldType#getNativeType() nativeType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nativeType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldType withNativeType(String value) {
    String newValue = Objects.requireNonNull(value, "nativeType");
    if (this.nativeType.equals(newValue)) return this;
    return new ImmutableFieldType(this.type, newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldType#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldType withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFieldType(this.type, this.nativeType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldType
        && equalTo(0, (ImmutableFieldType) another);
  }

  private boolean equalTo(int synthetic, ImmutableFieldType another) {
    return type.equals(another.type)
        && nativeType.equals(another.nativeType)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code nativeType}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + nativeType.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code FieldType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FieldType{"
        + "type=" + type
        + ", nativeType=" + nativeType
        + ", description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FieldType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements FieldType {
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String nativeType;
    @javax.annotation.Nullable String description;
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("nativeType")
    public void setNativeType(String nativeType) {
      this.nativeType = nativeType;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getNativeType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFieldType fromJson(Json json) {
    ImmutableFieldType.Builder builder = ImmutableFieldType.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.nativeType != null) {
      builder.nativeType(json.nativeType);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FieldType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldType instance
   */
  public static ImmutableFieldType copyOf(FieldType instance) {
    if (instance instanceof ImmutableFieldType) {
      return (ImmutableFieldType) instance;
    }
    return ImmutableFieldType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldType ImmutableFieldType}.
   * <pre>
   * ImmutableFieldType.builder()
   *    .type(String) // required {@link FieldType#getType() type}
   *    .nativeType(String) // required {@link FieldType#getNativeType() nativeType}
   *    .description(String | null) // nullable {@link FieldType#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableFieldType builder
   */
  public static ImmutableFieldType.Builder builder() {
    return new ImmutableFieldType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldType ImmutableFieldType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NATIVE_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String nativeType;
    private @javax.annotation.Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldType instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.getType());
      this.nativeType(instance.getNativeType());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FieldType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldType#getNativeType() nativeType} attribute.
     * @param nativeType The value for nativeType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nativeType")
    public final Builder nativeType(String nativeType) {
      this.nativeType = Objects.requireNonNull(nativeType, "nativeType");
      initBits &= ~INIT_BIT_NATIVE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldType#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldType ImmutableFieldType}.
     * @return An immutable instance of FieldType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFieldType(type, nativeType, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NATIVE_TYPE) != 0) attributes.add("nativeType");
      return "Cannot build FieldType, some of required attributes are not set " + attributes;
    }
  }
}
