package zeenea.connector.databricks.unitycatalog.rest.client.model.fields;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ArrayFieldType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArrayFieldType.builder()}.
 */
@Generated(from = "ArrayFieldType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableArrayFieldType
    implements ArrayFieldType {
  private final @Nullable String description;
  private final boolean containsNullable;
  private final String type;
  private final FieldType elementType;

  private ImmutableArrayFieldType(
      @Nullable String description,
      boolean containsNullable,
      String type,
      FieldType elementType) {
    this.description = description;
    this.containsNullable = containsNullable;
    this.type = type;
    this.elementType = elementType;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code containsNullable} attribute
   */
  @JsonProperty("containsNull")
  @Override
  public boolean getContainsNullable() {
    return containsNullable;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code elementType} attribute
   */
  @JsonProperty("elementType")
  @Override
  public FieldType getElementType() {
    return elementType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayFieldType#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayFieldType withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableArrayFieldType(value, this.containsNullable, this.type, this.elementType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayFieldType#getContainsNullable() containsNullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for containsNullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayFieldType withContainsNullable(boolean value) {
    if (this.containsNullable == value) return this;
    return new ImmutableArrayFieldType(this.description, value, this.type, this.elementType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayFieldType#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayFieldType withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableArrayFieldType(this.description, this.containsNullable, newValue, this.elementType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArrayFieldType#getElementType() elementType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArrayFieldType withElementType(FieldType value) {
    if (this.elementType == value) return this;
    FieldType newValue = Objects.requireNonNull(value, "elementType");
    return new ImmutableArrayFieldType(this.description, this.containsNullable, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArrayFieldType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArrayFieldType
        && equalTo(0, (ImmutableArrayFieldType) another);
  }

  private boolean equalTo(int synthetic, ImmutableArrayFieldType another) {
    return Objects.equals(description, another.description)
        && containsNullable == another.containsNullable
        && type.equals(another.type)
        && elementType.equals(another.elementType);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code containsNullable}, {@code type}, {@code elementType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Boolean.hashCode(containsNullable);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + elementType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ArrayFieldType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ArrayFieldType{"
        + "description=" + description
        + ", containsNullable=" + containsNullable
        + ", type=" + type
        + ", elementType=" + elementType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ArrayFieldType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ArrayFieldType {
    @javax.annotation.Nullable String description;
    boolean containsNullable;
    boolean containsNullableIsSet;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable FieldType elementType;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("containsNull")
    public void setContainsNullable(boolean containsNullable) {
      this.containsNullable = containsNullable;
      this.containsNullableIsSet = true;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("elementType")
    public void setElementType(FieldType elementType) {
      this.elementType = elementType;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getContainsNullable() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public FieldType getElementType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableArrayFieldType fromJson(Json json) {
    ImmutableArrayFieldType.Builder builder = ImmutableArrayFieldType.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.containsNullableIsSet) {
      builder.containsNullable(json.containsNullable);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.elementType != null) {
      builder.elementType(json.elementType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ArrayFieldType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ArrayFieldType instance
   */
  public static ImmutableArrayFieldType copyOf(ArrayFieldType instance) {
    if (instance instanceof ImmutableArrayFieldType) {
      return (ImmutableArrayFieldType) instance;
    }
    return ImmutableArrayFieldType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArrayFieldType ImmutableArrayFieldType}.
   * <pre>
   * ImmutableArrayFieldType.builder()
   *    .description(String | null) // nullable {@link ArrayFieldType#getDescription() description}
   *    .containsNullable(boolean) // required {@link ArrayFieldType#getContainsNullable() containsNullable}
   *    .type(String) // required {@link ArrayFieldType#getType() type}
   *    .elementType(zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType) // required {@link ArrayFieldType#getElementType() elementType}
   *    .build();
   * </pre>
   * @return A new ImmutableArrayFieldType builder
   */
  public static ImmutableArrayFieldType.Builder builder() {
    return new ImmutableArrayFieldType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArrayFieldType ImmutableArrayFieldType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ArrayFieldType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONTAINS_NULLABLE = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_ELEMENT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @javax.annotation.Nullable String description;
    private boolean containsNullable;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable FieldType elementType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.ArrayFieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ArrayFieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof ArrayFieldType) {
        ArrayFieldType instance = (ArrayFieldType) object;
        this.containsNullable(instance.getContainsNullable());
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        this.elementType(instance.getElementType());
      }
      if (object instanceof FieldType) {
        FieldType instance = (FieldType) object;
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ArrayFieldType#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link ArrayFieldType#getContainsNullable() containsNullable} attribute.
     * @param containsNullable The value for containsNullable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("containsNull")
    public final Builder containsNullable(boolean containsNullable) {
      this.containsNullable = containsNullable;
      initBits &= ~INIT_BIT_CONTAINS_NULLABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link ArrayFieldType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ArrayFieldType#getElementType() elementType} attribute.
     * @param elementType The value for elementType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("elementType")
    public final Builder elementType(FieldType elementType) {
      this.elementType = Objects.requireNonNull(elementType, "elementType");
      initBits &= ~INIT_BIT_ELEMENT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArrayFieldType ImmutableArrayFieldType}.
     * @return An immutable instance of ArrayFieldType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArrayFieldType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArrayFieldType(description, containsNullable, type, elementType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTAINS_NULLABLE) != 0) attributes.add("containsNullable");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_ELEMENT_TYPE) != 0) attributes.add("elementType");
      return "Cannot build ArrayFieldType, some of required attributes are not set " + attributes;
    }
  }
}
