package zeenea.connector.databricks.hivemetastore.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MetadataQueryResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMetadataQueryResult.builder()}.
 */
@Generated(from = "MetadataQueryResult", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMetadataQueryResult
    implements MetadataQueryResult {
  private final String name;
  private final String type;
  private final String comment;

  private ImmutableMetadataQueryResult(String name, String type, String comment) {
    this.name = name;
    this.type = type;
    this.comment = comment;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public String getComment() {
    return comment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetadataQueryResult#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadataQueryResult withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableMetadataQueryResult(newValue, this.type, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetadataQueryResult#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadataQueryResult withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableMetadataQueryResult(this.name, newValue, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetadataQueryResult#getComment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadataQueryResult withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (this.comment.equals(newValue)) return this;
    return new ImmutableMetadataQueryResult(this.name, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMetadataQueryResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMetadataQueryResult
        && equalTo(0, (ImmutableMetadataQueryResult) another);
  }

  private boolean equalTo(int synthetic, ImmutableMetadataQueryResult another) {
    return name.equals(another.name)
        && type.equals(another.type)
        && comment.equals(another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + comment.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MetadataQueryResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MetadataQueryResult{"
        + "name=" + name
        + ", type=" + type
        + ", comment=" + comment
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MetadataQueryResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MetadataQueryResult instance
   */
  public static ImmutableMetadataQueryResult copyOf(MetadataQueryResult instance) {
    if (instance instanceof ImmutableMetadataQueryResult) {
      return (ImmutableMetadataQueryResult) instance;
    }
    return ImmutableMetadataQueryResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMetadataQueryResult ImmutableMetadataQueryResult}.
   * <pre>
   * ImmutableMetadataQueryResult.builder()
   *    .name(String) // required {@link MetadataQueryResult#getName() name}
   *    .type(String) // required {@link MetadataQueryResult#getType() type}
   *    .comment(String) // required {@link MetadataQueryResult#getComment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutableMetadataQueryResult builder
   */
  public static ImmutableMetadataQueryResult.Builder builder() {
    return new ImmutableMetadataQueryResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMetadataQueryResult ImmutableMetadataQueryResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MetadataQueryResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_COMMENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String name;
    private @Nullable String type;
    private @Nullable String comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MetadataQueryResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MetadataQueryResult instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.type(instance.getType());
      this.comment(instance.getComment());
      return this;
    }

    /**
     * Initializes the value for the {@link MetadataQueryResult#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MetadataQueryResult#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link MetadataQueryResult#getComment() comment} attribute.
     * @param comment The value for comment 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      initBits &= ~INIT_BIT_COMMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMetadataQueryResult ImmutableMetadataQueryResult}.
     * @return An immutable instance of MetadataQueryResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMetadataQueryResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMetadataQueryResult(name, type, comment);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_COMMENT) != 0) attributes.add("comment");
      return "Cannot build MetadataQueryResult, some of required attributes are not set " + attributes;
    }
  }
}
