package zeenea.connector.databricks.commons.client.constraints;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ForeignKeyConstraint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableForeignKeyConstraint.builder()}.
 */
@Generated(from = "ForeignKeyConstraint", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableForeignKeyConstraint
    implements ForeignKeyConstraint {
  private final String name;
  private final List<String> childColumns;
  private final String parentTable;
  private final List<String> parentColumns;

  private ImmutableForeignKeyConstraint() {
    this.name = null;
    this.childColumns = null;
    this.parentTable = null;
    this.parentColumns = null;
  }

  private ImmutableForeignKeyConstraint(
      String name,
      List<String> childColumns,
      String parentTable,
      List<String> parentColumns) {
    this.name = name;
    this.childColumns = childColumns;
    this.parentTable = parentTable;
    this.parentColumns = parentColumns;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code childColumns} attribute
   */
  @JsonProperty("child_columns")
  @Override
  public List<String> getChildColumns() {
    return childColumns;
  }

  /**
   * @return The value of the {@code parentTable} attribute
   */
  @JsonProperty("parent_table")
  @Override
  public String getParentTable() {
    return parentTable;
  }

  /**
   * @return The value of the {@code parentColumns} attribute
   */
  @JsonProperty("parent_columns")
  @Override
  public List<String> getParentColumns() {
    return parentColumns;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForeignKeyConstraint#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForeignKeyConstraint withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableForeignKeyConstraint(newValue, this.childColumns, this.parentTable, this.parentColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForeignKeyConstraint#getChildColumns() childColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForeignKeyConstraint withChildColumns(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableForeignKeyConstraint(this.name, newValue, this.parentTable, this.parentColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForeignKeyConstraint#getChildColumns() childColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of childColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForeignKeyConstraint withChildColumns(Iterable<String> elements) {
    if (this.childColumns == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableForeignKeyConstraint(this.name, newValue, this.parentTable, this.parentColumns);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForeignKeyConstraint#getParentTable() parentTable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentTable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForeignKeyConstraint withParentTable(String value) {
    String newValue = Objects.requireNonNull(value, "parentTable");
    if (Objects.equals(this.parentTable, newValue)) return this;
    return new ImmutableForeignKeyConstraint(this.name, this.childColumns, newValue, this.parentColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForeignKeyConstraint#getParentColumns() parentColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForeignKeyConstraint withParentColumns(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableForeignKeyConstraint(this.name, this.childColumns, this.parentTable, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForeignKeyConstraint#getParentColumns() parentColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parentColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForeignKeyConstraint withParentColumns(Iterable<String> elements) {
    if (this.parentColumns == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableForeignKeyConstraint(this.name, this.childColumns, this.parentTable, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForeignKeyConstraint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForeignKeyConstraint
        && equalTo(0, (ImmutableForeignKeyConstraint) another);
  }

  private boolean equalTo(int synthetic, ImmutableForeignKeyConstraint another) {
    return name.equals(another.name)
        && childColumns.equals(another.childColumns)
        && parentTable.equals(another.parentTable)
        && parentColumns.equals(another.parentColumns);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code childColumns}, {@code parentTable}, {@code parentColumns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + childColumns.hashCode();
    h += (h << 5) + parentTable.hashCode();
    h += (h << 5) + parentColumns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ForeignKeyConstraint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ForeignKeyConstraint{"
        + "name=" + name
        + ", childColumns=" + childColumns
        + ", parentTable=" + parentTable
        + ", parentColumns=" + parentColumns
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ForeignKeyConstraint", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ForeignKeyConstraint {
    @Nullable String name;
    @Nullable List<String> childColumns = Collections.emptyList();
    @Nullable String parentTable;
    @Nullable List<String> parentColumns = Collections.emptyList();
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("child_columns")
    public void setChildColumns(List<String> childColumns) {
      this.childColumns = childColumns;
    }
    @JsonProperty("parent_table")
    public void setParentTable(String parentTable) {
      this.parentTable = parentTable;
    }
    @JsonProperty("parent_columns")
    public void setParentColumns(List<String> parentColumns) {
      this.parentColumns = parentColumns;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChildColumns() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentTable() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getParentColumns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableForeignKeyConstraint fromJson(Json json) {
    ImmutableForeignKeyConstraint.Builder builder = ImmutableForeignKeyConstraint.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.childColumns != null) {
      builder.addAllChildColumns(json.childColumns);
    }
    if (json.parentTable != null) {
      builder.parentTable(json.parentTable);
    }
    if (json.parentColumns != null) {
      builder.addAllParentColumns(json.parentColumns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ForeignKeyConstraint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ForeignKeyConstraint instance
   */
  public static ImmutableForeignKeyConstraint copyOf(ForeignKeyConstraint instance) {
    if (instance instanceof ImmutableForeignKeyConstraint) {
      return (ImmutableForeignKeyConstraint) instance;
    }
    return ImmutableForeignKeyConstraint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableForeignKeyConstraint ImmutableForeignKeyConstraint}.
   * <pre>
   * ImmutableForeignKeyConstraint.builder()
   *    .name(String) // required {@link ForeignKeyConstraint#getName() name}
   *    .addChildColumns|addAllChildColumns(String) // {@link ForeignKeyConstraint#getChildColumns() childColumns} elements
   *    .parentTable(String) // required {@link ForeignKeyConstraint#getParentTable() parentTable}
   *    .addParentColumns|addAllParentColumns(String) // {@link ForeignKeyConstraint#getParentColumns() parentColumns} elements
   *    .build();
   * </pre>
   * @return A new ImmutableForeignKeyConstraint builder
   */
  public static ImmutableForeignKeyConstraint.Builder builder() {
    return new ImmutableForeignKeyConstraint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableForeignKeyConstraint ImmutableForeignKeyConstraint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ForeignKeyConstraint", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_PARENT_TABLE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private List<String> childColumns = new ArrayList<String>();
    private @Nullable String parentTable;
    private List<String> parentColumns = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ForeignKeyConstraint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ForeignKeyConstraint instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      addAllChildColumns(instance.getChildColumns());
      this.parentTable(instance.getParentTable());
      addAllParentColumns(instance.getParentColumns());
      return this;
    }

    /**
     * Initializes the value for the {@link ForeignKeyConstraint#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ForeignKeyConstraint#getChildColumns() childColumns} list.
     * @param element A childColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChildColumns(String element) {
      this.childColumns.add(Objects.requireNonNull(element, "childColumns element"));
      return this;
    }

    /**
     * Adds elements to {@link ForeignKeyConstraint#getChildColumns() childColumns} list.
     * @param elements An array of childColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChildColumns(String... elements) {
      for (String element : elements) {
        this.childColumns.add(Objects.requireNonNull(element, "childColumns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForeignKeyConstraint#getChildColumns() childColumns} list.
     * @param elements An iterable of childColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("child_columns")
    public final Builder childColumns(Iterable<String> elements) {
      this.childColumns.clear();
      return addAllChildColumns(elements);
    }

    /**
     * Adds elements to {@link ForeignKeyConstraint#getChildColumns() childColumns} list.
     * @param elements An iterable of childColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChildColumns(Iterable<String> elements) {
      for (String element : elements) {
        this.childColumns.add(Objects.requireNonNull(element, "childColumns element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ForeignKeyConstraint#getParentTable() parentTable} attribute.
     * @param parentTable The value for parentTable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parent_table")
    public final Builder parentTable(String parentTable) {
      this.parentTable = Objects.requireNonNull(parentTable, "parentTable");
      initBits &= ~INIT_BIT_PARENT_TABLE;
      return this;
    }

    /**
     * Adds one element to {@link ForeignKeyConstraint#getParentColumns() parentColumns} list.
     * @param element A parentColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParentColumns(String element) {
      this.parentColumns.add(Objects.requireNonNull(element, "parentColumns element"));
      return this;
    }

    /**
     * Adds elements to {@link ForeignKeyConstraint#getParentColumns() parentColumns} list.
     * @param elements An array of parentColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParentColumns(String... elements) {
      for (String element : elements) {
        this.parentColumns.add(Objects.requireNonNull(element, "parentColumns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForeignKeyConstraint#getParentColumns() parentColumns} list.
     * @param elements An iterable of parentColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parent_columns")
    public final Builder parentColumns(Iterable<String> elements) {
      this.parentColumns.clear();
      return addAllParentColumns(elements);
    }

    /**
     * Adds elements to {@link ForeignKeyConstraint#getParentColumns() parentColumns} list.
     * @param elements An iterable of parentColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllParentColumns(Iterable<String> elements) {
      for (String element : elements) {
        this.parentColumns.add(Objects.requireNonNull(element, "parentColumns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableForeignKeyConstraint ImmutableForeignKeyConstraint}.
     * @return An immutable instance of ForeignKeyConstraint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForeignKeyConstraint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableForeignKeyConstraint(
          name,
          createUnmodifiableList(true, childColumns),
          parentTable,
          createUnmodifiableList(true, parentColumns));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PARENT_TABLE) != 0) attributes.add("parentTable");
      return "Cannot build ForeignKeyConstraint, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
