package zeenea.connector.databricks.commons.client.constraints;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Constraint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConstraint.builder()}.
 */
@Generated(from = "Constraint", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableConstraint
    implements Constraint {
  private final @Nullable PrimaryKeyConstraint primaryKeyConstraint;
  private final @Nullable ForeignKeyConstraint foreignKeyConstraint;
  private final String constraintId;
  private final String tableId;

  private ImmutableConstraint() {
    this.primaryKeyConstraint = null;
    this.foreignKeyConstraint = null;
    this.constraintId = null;
    this.tableId = null;
  }

  private ImmutableConstraint(
      @Nullable PrimaryKeyConstraint primaryKeyConstraint,
      @Nullable ForeignKeyConstraint foreignKeyConstraint,
      String constraintId,
      String tableId) {
    this.primaryKeyConstraint = primaryKeyConstraint;
    this.foreignKeyConstraint = foreignKeyConstraint;
    this.constraintId = constraintId;
    this.tableId = tableId;
  }

  /**
   * @return The value of the {@code primaryKeyConstraint} attribute
   */
  @JsonProperty("primary_key_constraint")
  @Override
  public @Nullable PrimaryKeyConstraint getPrimaryKeyConstraint() {
    return primaryKeyConstraint;
  }

  /**
   * @return The value of the {@code foreignKeyConstraint} attribute
   */
  @JsonProperty("foreign_key_constraint")
  @Override
  public @Nullable ForeignKeyConstraint getForeignKeyConstraint() {
    return foreignKeyConstraint;
  }

  /**
   * @return The value of the {@code constraintId} attribute
   */
  @JsonProperty("constraint_id")
  @Override
  public String getConstraintId() {
    return constraintId;
  }

  /**
   * @return The value of the {@code tableId} attribute
   */
  @JsonProperty("table_id")
  @Override
  public String getTableId() {
    return tableId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constraint#getPrimaryKeyConstraint() primaryKeyConstraint} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for primaryKeyConstraint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraint withPrimaryKeyConstraint(@Nullable PrimaryKeyConstraint value) {
    if (this.primaryKeyConstraint == value) return this;
    return new ImmutableConstraint(value, this.foreignKeyConstraint, this.constraintId, this.tableId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constraint#getForeignKeyConstraint() foreignKeyConstraint} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for foreignKeyConstraint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraint withForeignKeyConstraint(@Nullable ForeignKeyConstraint value) {
    if (this.foreignKeyConstraint == value) return this;
    return new ImmutableConstraint(this.primaryKeyConstraint, value, this.constraintId, this.tableId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constraint#getConstraintId() constraintId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constraintId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraint withConstraintId(String value) {
    String newValue = Objects.requireNonNull(value, "constraintId");
    if (Objects.equals(this.constraintId, newValue)) return this;
    return new ImmutableConstraint(this.primaryKeyConstraint, this.foreignKeyConstraint, newValue, this.tableId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constraint#getTableId() tableId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstraint withTableId(String value) {
    String newValue = Objects.requireNonNull(value, "tableId");
    if (Objects.equals(this.tableId, newValue)) return this;
    return new ImmutableConstraint(this.primaryKeyConstraint, this.foreignKeyConstraint, this.constraintId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConstraint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConstraint
        && equalTo(0, (ImmutableConstraint) another);
  }

  private boolean equalTo(int synthetic, ImmutableConstraint another) {
    return Objects.equals(primaryKeyConstraint, another.primaryKeyConstraint)
        && Objects.equals(foreignKeyConstraint, another.foreignKeyConstraint)
        && constraintId.equals(another.constraintId)
        && tableId.equals(another.tableId);
  }

  /**
   * Computes a hash code from attributes: {@code primaryKeyConstraint}, {@code foreignKeyConstraint}, {@code constraintId}, {@code tableId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(primaryKeyConstraint);
    h += (h << 5) + Objects.hashCode(foreignKeyConstraint);
    h += (h << 5) + constraintId.hashCode();
    h += (h << 5) + tableId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Constraint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Constraint{"
        + "primaryKeyConstraint=" + primaryKeyConstraint
        + ", foreignKeyConstraint=" + foreignKeyConstraint
        + ", constraintId=" + constraintId
        + ", tableId=" + tableId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Constraint", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Constraint {
    @javax.annotation.Nullable PrimaryKeyConstraint primaryKeyConstraint;
    @javax.annotation.Nullable ForeignKeyConstraint foreignKeyConstraint;
    @javax.annotation.Nullable String constraintId;
    @javax.annotation.Nullable String tableId;
    @JsonProperty("primary_key_constraint")
    public void setPrimaryKeyConstraint(@Nullable PrimaryKeyConstraint primaryKeyConstraint) {
      this.primaryKeyConstraint = primaryKeyConstraint;
    }
    @JsonProperty("foreign_key_constraint")
    public void setForeignKeyConstraint(@Nullable ForeignKeyConstraint foreignKeyConstraint) {
      this.foreignKeyConstraint = foreignKeyConstraint;
    }
    @JsonProperty("constraint_id")
    public void setConstraintId(String constraintId) {
      this.constraintId = constraintId;
    }
    @JsonProperty("table_id")
    public void setTableId(String tableId) {
      this.tableId = tableId;
    }
    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() { throw new UnsupportedOperationException(); }
    @Override
    public ForeignKeyConstraint getForeignKeyConstraint() { throw new UnsupportedOperationException(); }
    @Override
    public String getConstraintId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConstraint fromJson(Json json) {
    ImmutableConstraint.Builder builder = ImmutableConstraint.builder();
    if (json.primaryKeyConstraint != null) {
      builder.primaryKeyConstraint(json.primaryKeyConstraint);
    }
    if (json.foreignKeyConstraint != null) {
      builder.foreignKeyConstraint(json.foreignKeyConstraint);
    }
    if (json.constraintId != null) {
      builder.constraintId(json.constraintId);
    }
    if (json.tableId != null) {
      builder.tableId(json.tableId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Constraint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Constraint instance
   */
  public static ImmutableConstraint copyOf(Constraint instance) {
    if (instance instanceof ImmutableConstraint) {
      return (ImmutableConstraint) instance;
    }
    return ImmutableConstraint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConstraint ImmutableConstraint}.
   * <pre>
   * ImmutableConstraint.builder()
   *    .primaryKeyConstraint(zeenea.connector.databricks.commons.client.constraints.PrimaryKeyConstraint | null) // nullable {@link Constraint#getPrimaryKeyConstraint() primaryKeyConstraint}
   *    .foreignKeyConstraint(zeenea.connector.databricks.commons.client.constraints.ForeignKeyConstraint | null) // nullable {@link Constraint#getForeignKeyConstraint() foreignKeyConstraint}
   *    .constraintId(String) // required {@link Constraint#getConstraintId() constraintId}
   *    .tableId(String) // required {@link Constraint#getTableId() tableId}
   *    .build();
   * </pre>
   * @return A new ImmutableConstraint builder
   */
  public static ImmutableConstraint.Builder builder() {
    return new ImmutableConstraint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConstraint ImmutableConstraint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Constraint", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONSTRAINT_ID = 0x1L;
    private static final long INIT_BIT_TABLE_ID = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable PrimaryKeyConstraint primaryKeyConstraint;
    private @javax.annotation.Nullable ForeignKeyConstraint foreignKeyConstraint;
    private @javax.annotation.Nullable String constraintId;
    private @javax.annotation.Nullable String tableId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Constraint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Constraint instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable PrimaryKeyConstraint primaryKeyConstraintValue = instance.getPrimaryKeyConstraint();
      if (primaryKeyConstraintValue != null) {
        primaryKeyConstraint(primaryKeyConstraintValue);
      }
      @Nullable ForeignKeyConstraint foreignKeyConstraintValue = instance.getForeignKeyConstraint();
      if (foreignKeyConstraintValue != null) {
        foreignKeyConstraint(foreignKeyConstraintValue);
      }
      this.constraintId(instance.getConstraintId());
      this.tableId(instance.getTableId());
      return this;
    }

    /**
     * Initializes the value for the {@link Constraint#getPrimaryKeyConstraint() primaryKeyConstraint} attribute.
     * @param primaryKeyConstraint The value for primaryKeyConstraint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("primary_key_constraint")
    public final Builder primaryKeyConstraint(@Nullable PrimaryKeyConstraint primaryKeyConstraint) {
      this.primaryKeyConstraint = primaryKeyConstraint;
      return this;
    }

    /**
     * Initializes the value for the {@link Constraint#getForeignKeyConstraint() foreignKeyConstraint} attribute.
     * @param foreignKeyConstraint The value for foreignKeyConstraint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("foreign_key_constraint")
    public final Builder foreignKeyConstraint(@Nullable ForeignKeyConstraint foreignKeyConstraint) {
      this.foreignKeyConstraint = foreignKeyConstraint;
      return this;
    }

    /**
     * Initializes the value for the {@link Constraint#getConstraintId() constraintId} attribute.
     * @param constraintId The value for constraintId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("constraint_id")
    public final Builder constraintId(String constraintId) {
      this.constraintId = Objects.requireNonNull(constraintId, "constraintId");
      initBits &= ~INIT_BIT_CONSTRAINT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Constraint#getTableId() tableId} attribute.
     * @param tableId The value for tableId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_id")
    public final Builder tableId(String tableId) {
      this.tableId = Objects.requireNonNull(tableId, "tableId");
      initBits &= ~INIT_BIT_TABLE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConstraint ImmutableConstraint}.
     * @return An immutable instance of Constraint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConstraint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConstraint(primaryKeyConstraint, foreignKeyConstraint, constraintId, tableId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONSTRAINT_ID) != 0) attributes.add("constraintId");
      if ((initBits & INIT_BIT_TABLE_ID) != 0) attributes.add("tableId");
      return "Cannot build Constraint, some of required attributes are not set " + attributes;
    }
  }
}
