package zeenea.connector.databricks.commons.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ViewDependencies}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableViewDependencies.builder()}.
 */
@Generated(from = "ViewDependencies", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableViewDependencies
    implements ViewDependencies {
  private final @Nullable List<ViewDependency> dependencies;

  private ImmutableViewDependencies() {
    this.dependencies = null;
  }

  private ImmutableViewDependencies(
      @Nullable List<ViewDependency> dependencies) {
    this.dependencies = dependencies;
  }

  /**
   * @return The value of the {@code dependencies} attribute
   */
  @JsonProperty("dependencies")
  @Override
  public @Nullable List<ViewDependency> getDependencies() {
    return dependencies;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDependencies#getDependencies() dependencies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDependencies withDependencies(@Nullable ViewDependency... elements) {
    if (elements == null) {
      return new ImmutableViewDependencies(null);
    }
    @Nullable List<ViewDependency> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableViewDependencies(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ViewDependencies#getDependencies() dependencies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dependencies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableViewDependencies withDependencies(@Nullable Iterable<? extends ViewDependency> elements) {
    if (this.dependencies == elements) return this;
    @Nullable List<ViewDependency> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableViewDependencies(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableViewDependencies} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableViewDependencies
        && equalTo(0, (ImmutableViewDependencies) another);
  }

  private boolean equalTo(int synthetic, ImmutableViewDependencies another) {
    return Objects.equals(dependencies, another.dependencies);
  }

  /**
   * Computes a hash code from attributes: {@code dependencies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(dependencies);
    return h;
  }

  /**
   * Prints the immutable value {@code ViewDependencies} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewDependencies{"
        + "dependencies=" + dependencies
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ViewDependencies", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewDependencies {
    @javax.annotation.Nullable List<ViewDependency> dependencies = null;
    @JsonProperty("dependencies")
    public void setDependencies(@Nullable List<ViewDependency> dependencies) {
      this.dependencies = dependencies;
    }
    @Override
    public List<ViewDependency> getDependencies() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableViewDependencies fromJson(Json json) {
    ImmutableViewDependencies.Builder builder = ImmutableViewDependencies.builder();
    if (json.dependencies != null) {
      builder.addAllDependencies(json.dependencies);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewDependencies} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewDependencies instance
   */
  public static ImmutableViewDependencies copyOf(ViewDependencies instance) {
    if (instance instanceof ImmutableViewDependencies) {
      return (ImmutableViewDependencies) instance;
    }
    return ImmutableViewDependencies.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableViewDependencies ImmutableViewDependencies}.
   * <pre>
   * ImmutableViewDependencies.builder()
   *    .dependencies(List&amp;lt;zeenea.connector.databricks.commons.client.ViewDependency&amp;gt; | null) // nullable {@link ViewDependencies#getDependencies() dependencies}
   *    .build();
   * </pre>
   * @return A new ImmutableViewDependencies builder
   */
  public static ImmutableViewDependencies.Builder builder() {
    return new ImmutableViewDependencies.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableViewDependencies ImmutableViewDependencies}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ViewDependencies", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<ViewDependency> dependencies = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewDependencies} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewDependencies instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<ViewDependency> dependenciesValue = instance.getDependencies();
      if (dependenciesValue != null) {
        addAllDependencies(dependenciesValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link ViewDependencies#getDependencies() dependencies} list.
     * @param element A dependencies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDependencies(ViewDependency element) {
      if (this.dependencies == null) {
        this.dependencies = new ArrayList<ViewDependency>();
      }
      this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
      return this;
    }

    /**
     * Adds elements to {@link ViewDependencies#getDependencies() dependencies} list.
     * @param elements An array of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDependencies(ViewDependency... elements) {
      if (this.dependencies == null) {
        this.dependencies = new ArrayList<ViewDependency>();
      }
      for (ViewDependency element : elements) {
        this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ViewDependencies#getDependencies() dependencies} list.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dependencies")
    public final Builder dependencies(@Nullable Iterable<? extends ViewDependency> elements) {
      if (elements == null) {
        this.dependencies = null;
        return this;
      }
      this.dependencies = new ArrayList<ViewDependency>();
      return addAllDependencies(elements);
    }

    /**
     * Adds elements to {@link ViewDependencies#getDependencies() dependencies} list.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDependencies(Iterable<? extends ViewDependency> elements) {
      Objects.requireNonNull(elements, "dependencies element");
      if (this.dependencies == null) {
        this.dependencies = new ArrayList<ViewDependency>();
      }
      for (ViewDependency element : elements) {
        this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableViewDependencies ImmutableViewDependencies}.
     * @return An immutable instance of ViewDependencies
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableViewDependencies build() {
      return new ImmutableViewDependencies(dependencies == null ? null : createUnmodifiableList(true, dependencies));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
