package zeenea.connector.databricks.commons.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.databricks.commons.client.constraints.Constraint;

/**
 * Immutable implementation of {@link Table}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTable.builder()}.
 */
@Generated(from = "Table", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTable implements Table {
  private final @Nullable String name;
  private final @Nullable String comment;
  private final @Nullable String catalogName;
  private final @Nullable String schemaName;
  private final @Nullable String metastoreId;
  private final @Nullable String tableType;
  private final @Nullable String datasourceFormat;
  private final List<Field> columns;
  private final @Nullable String storageLocation;
  private final @Nullable String createdAt;
  private final @Nullable String createdBy;
  private final @Nullable String updatedAt;
  private final @Nullable String updatedBy;
  private final @Nullable String tableId;
  private final @Nullable String partitionedBy;
  private final @Nullable List<Constraint> tableConstraints;
  private final @Nullable String fullName;
  private final @Nullable String viewDefinition;
  private final @Nullable ViewDependencies viewDependencies;

  private ImmutableTable() {
    this.name = null;
    this.comment = null;
    this.catalogName = null;
    this.schemaName = null;
    this.metastoreId = null;
    this.tableType = null;
    this.datasourceFormat = null;
    this.columns = null;
    this.storageLocation = null;
    this.createdAt = null;
    this.createdBy = null;
    this.updatedAt = null;
    this.updatedBy = null;
    this.tableId = null;
    this.partitionedBy = null;
    this.tableConstraints = null;
    this.fullName = null;
    this.viewDefinition = null;
    this.viewDependencies = null;
  }

  private ImmutableTable(ImmutableTable.Builder builder) {
    this.name = builder.name;
    this.comment = builder.comment;
    this.catalogName = builder.catalogName;
    this.schemaName = builder.schemaName;
    this.metastoreId = builder.metastoreId;
    this.tableType = builder.tableType;
    this.datasourceFormat = builder.datasourceFormat;
    this.storageLocation = builder.storageLocation;
    this.createdAt = builder.createdAt;
    this.createdBy = builder.createdBy;
    this.updatedAt = builder.updatedAt;
    this.updatedBy = builder.updatedBy;
    this.tableId = builder.tableId;
    this.partitionedBy = builder.partitionedBy;
    this.tableConstraints = builder.tableConstraints == null ? null : createUnmodifiableList(true, builder.tableConstraints);
    this.fullName = builder.fullName;
    this.viewDefinition = builder.viewDefinition;
    this.viewDependencies = builder.viewDependencies;
    this.columns = builder.columnsIsSet()
        ? createUnmodifiableList(true, builder.columns)
        : createUnmodifiableList(false, createSafeList(Table.super.getColumns(), true, false));
  }

  private ImmutableTable(
      @Nullable String name,
      @Nullable String comment,
      @Nullable String catalogName,
      @Nullable String schemaName,
      @Nullable String metastoreId,
      @Nullable String tableType,
      @Nullable String datasourceFormat,
      List<Field> columns,
      @Nullable String storageLocation,
      @Nullable String createdAt,
      @Nullable String createdBy,
      @Nullable String updatedAt,
      @Nullable String updatedBy,
      @Nullable String tableId,
      @Nullable String partitionedBy,
      @Nullable List<Constraint> tableConstraints,
      @Nullable String fullName,
      @Nullable String viewDefinition,
      @Nullable ViewDependencies viewDependencies) {
    this.name = name;
    this.comment = comment;
    this.catalogName = catalogName;
    this.schemaName = schemaName;
    this.metastoreId = metastoreId;
    this.tableType = tableType;
    this.datasourceFormat = datasourceFormat;
    this.columns = columns;
    this.storageLocation = storageLocation;
    this.createdAt = createdAt;
    this.createdBy = createdBy;
    this.updatedAt = updatedAt;
    this.updatedBy = updatedBy;
    this.tableId = tableId;
    this.partitionedBy = partitionedBy;
    this.tableConstraints = tableConstraints;
    this.fullName = fullName;
    this.viewDefinition = viewDefinition;
    this.viewDependencies = viewDependencies;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("comment")
  @Override
  public @Nullable String getComment() {
    return comment;
  }

  /**
   * @return The value of the {@code catalogName} attribute
   */
  @JsonProperty("catalog_name")
  @Override
  public @Nullable String getCatalogName() {
    return catalogName;
  }

  /**
   * @return The value of the {@code schemaName} attribute
   */
  @JsonProperty("schema_name")
  @Override
  public @Nullable String getSchemaName() {
    return schemaName;
  }

  /**
   * @return The value of the {@code metastoreId} attribute
   */
  @JsonProperty("metastore_id")
  @Override
  public @Nullable String getMetastoreId() {
    return metastoreId;
  }

  /**
   * @return The value of the {@code tableType} attribute
   */
  @JsonProperty("table_type")
  @Override
  public @Nullable String getTableType() {
    return tableType;
  }

  /**
   * @return The value of the {@code datasourceFormat} attribute
   */
  @JsonProperty("data_source_format")
  @Override
  public @Nullable String getDatasourceFormat() {
    return datasourceFormat;
  }

  /**
   * @return The value of the {@code columns} attribute
   */
  @JsonProperty("columns")
  @Override
  public List<Field> getColumns() {
    return columns;
  }

  /**
   * @return The value of the {@code storageLocation} attribute
   */
  @JsonProperty("storage_location")
  @Override
  public @Nullable String getStorageLocation() {
    return storageLocation;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code createdBy} attribute
   */
  @JsonProperty("created_by")
  @Override
  public @Nullable String getCreatedBy() {
    return createdBy;
  }

  /**
   * @return The value of the {@code updatedAt} attribute
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code updatedBy} attribute
   */
  @JsonProperty("updated_by")
  @Override
  public @Nullable String getUpdatedBy() {
    return updatedBy;
  }

  /**
   * @return The value of the {@code tableId} attribute
   */
  @JsonProperty("table_id")
  @Override
  public @Nullable String getTableId() {
    return tableId;
  }

  /**
   * @return The value of the {@code partitionedBy} attribute
   */
  @JsonProperty("partitionedBy")
  @Override
  public @Nullable String getPartitionedBy() {
    return partitionedBy;
  }

  /**
   * @return The value of the {@code tableConstraints} attribute
   */
  @JsonProperty("table_constraints")
  @Override
  public @Nullable List<Constraint> getTableConstraints() {
    return tableConstraints;
  }

  /**
   * @return The value of the {@code fullName} attribute
   */
  @JsonProperty("full_name")
  @Override
  public @Nullable String getFullName() {
    return fullName;
  }

  /**
   * @return The value of the {@code viewDefinition} attribute
   */
  @JsonProperty("view_definition")
  @Override
  public @Nullable String getViewDefinition() {
    return viewDefinition;
  }

  /**
   * @return The value of the {@code viewDependencies} attribute
   */
  @JsonProperty("view_dependencies")
  @Override
  public @Nullable ViewDependencies getViewDependencies() {
    return viewDependencies;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableTable(
        value,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getComment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withComment(@Nullable String value) {
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableTable(
        this.name,
        value,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getCatalogName() catalogName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalogName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withCatalogName(@Nullable String value) {
    if (Objects.equals(this.catalogName, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        value,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getSchemaName() schemaName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withSchemaName(@Nullable String value) {
    if (Objects.equals(this.schemaName, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        value,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getMetastoreId() metastoreId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metastoreId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withMetastoreId(@Nullable String value) {
    if (Objects.equals(this.metastoreId, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        value,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getTableType() tableType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withTableType(@Nullable String value) {
    if (Objects.equals(this.tableType, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        value,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getDatasourceFormat() datasourceFormat} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasourceFormat (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withDatasourceFormat(@Nullable String value) {
    if (Objects.equals(this.datasourceFormat, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        value,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#getColumns() columns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withColumns(Field... elements) {
    List<Field> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        newValue,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#getColumns() columns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of columns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withColumns(Iterable<? extends Field> elements) {
    if (this.columns == elements) return this;
    List<Field> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        newValue,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getStorageLocation() storageLocation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for storageLocation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withStorageLocation(@Nullable String value) {
    if (Objects.equals(this.storageLocation, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        value,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getCreatedAt() createdAt} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withCreatedAt(@Nullable String value) {
    if (Objects.equals(this.createdAt, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        value,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getCreatedBy() createdBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdBy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withCreatedBy(@Nullable String value) {
    if (Objects.equals(this.createdBy, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        value,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getUpdatedAt() updatedAt} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withUpdatedAt(@Nullable String value) {
    if (Objects.equals(this.updatedAt, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        value,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getUpdatedBy() updatedBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedBy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withUpdatedBy(@Nullable String value) {
    if (Objects.equals(this.updatedBy, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        value,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getTableId() tableId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withTableId(@Nullable String value) {
    if (Objects.equals(this.tableId, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        value,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getPartitionedBy() partitionedBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partitionedBy (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withPartitionedBy(@Nullable String value) {
    if (Objects.equals(this.partitionedBy, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        value,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#getTableConstraints() tableConstraints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withTableConstraints(@Nullable Constraint... elements) {
    if (elements == null) {
      return new ImmutableTable(
          this.name,
          this.comment,
          this.catalogName,
          this.schemaName,
          this.metastoreId,
          this.tableType,
          this.datasourceFormat,
          this.columns,
          this.storageLocation,
          this.createdAt,
          this.createdBy,
          this.updatedAt,
          this.updatedBy,
          this.tableId,
          this.partitionedBy,
          null,
          this.fullName,
          this.viewDefinition,
          this.viewDependencies);
    }
    @Nullable List<Constraint> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        newValue,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table#getTableConstraints() tableConstraints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tableConstraints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTable withTableConstraints(@Nullable Iterable<? extends Constraint> elements) {
    if (this.tableConstraints == elements) return this;
    @Nullable List<Constraint> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        newValue,
        this.fullName,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getFullName() fullName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fullName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withFullName(@Nullable String value) {
    if (Objects.equals(this.fullName, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        value,
        this.viewDefinition,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getViewDefinition() viewDefinition} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for viewDefinition (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withViewDefinition(@Nullable String value) {
    if (Objects.equals(this.viewDefinition, value)) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        value,
        this.viewDependencies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#getViewDependencies() viewDependencies} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for viewDependencies (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withViewDependencies(@Nullable ViewDependencies value) {
    if (this.viewDependencies == value) return this;
    return new ImmutableTable(
        this.name,
        this.comment,
        this.catalogName,
        this.schemaName,
        this.metastoreId,
        this.tableType,
        this.datasourceFormat,
        this.columns,
        this.storageLocation,
        this.createdAt,
        this.createdBy,
        this.updatedAt,
        this.updatedBy,
        this.tableId,
        this.partitionedBy,
        this.tableConstraints,
        this.fullName,
        this.viewDefinition,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTable
        && equalTo(0, (ImmutableTable) another);
  }

  private boolean equalTo(int synthetic, ImmutableTable another) {
    return Objects.equals(name, another.name)
        && Objects.equals(comment, another.comment)
        && Objects.equals(catalogName, another.catalogName)
        && Objects.equals(schemaName, another.schemaName)
        && Objects.equals(metastoreId, another.metastoreId)
        && Objects.equals(tableType, another.tableType)
        && Objects.equals(datasourceFormat, another.datasourceFormat)
        && columns.equals(another.columns)
        && Objects.equals(storageLocation, another.storageLocation)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(createdBy, another.createdBy)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(updatedBy, another.updatedBy)
        && Objects.equals(tableId, another.tableId)
        && Objects.equals(partitionedBy, another.partitionedBy)
        && Objects.equals(tableConstraints, another.tableConstraints)
        && Objects.equals(fullName, another.fullName)
        && Objects.equals(viewDefinition, another.viewDefinition)
        && Objects.equals(viewDependencies, another.viewDependencies);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code comment}, {@code catalogName}, {@code schemaName}, {@code metastoreId}, {@code tableType}, {@code datasourceFormat}, {@code columns}, {@code storageLocation}, {@code createdAt}, {@code createdBy}, {@code updatedAt}, {@code updatedBy}, {@code tableId}, {@code partitionedBy}, {@code tableConstraints}, {@code fullName}, {@code viewDefinition}, {@code viewDependencies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Objects.hashCode(catalogName);
    h += (h << 5) + Objects.hashCode(schemaName);
    h += (h << 5) + Objects.hashCode(metastoreId);
    h += (h << 5) + Objects.hashCode(tableType);
    h += (h << 5) + Objects.hashCode(datasourceFormat);
    h += (h << 5) + columns.hashCode();
    h += (h << 5) + Objects.hashCode(storageLocation);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(createdBy);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(updatedBy);
    h += (h << 5) + Objects.hashCode(tableId);
    h += (h << 5) + Objects.hashCode(partitionedBy);
    h += (h << 5) + Objects.hashCode(tableConstraints);
    h += (h << 5) + Objects.hashCode(fullName);
    h += (h << 5) + Objects.hashCode(viewDefinition);
    h += (h << 5) + Objects.hashCode(viewDependencies);
    return h;
  }

  /**
   * Prints the immutable value {@code Table} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Table{"
        + "name=" + name
        + ", comment=" + comment
        + ", catalogName=" + catalogName
        + ", schemaName=" + schemaName
        + ", metastoreId=" + metastoreId
        + ", tableType=" + tableType
        + ", datasourceFormat=" + datasourceFormat
        + ", columns=" + columns
        + ", storageLocation=" + storageLocation
        + ", createdAt=" + createdAt
        + ", createdBy=" + createdBy
        + ", updatedAt=" + updatedAt
        + ", updatedBy=" + updatedBy
        + ", tableId=" + tableId
        + ", partitionedBy=" + partitionedBy
        + ", tableConstraints=" + tableConstraints
        + ", fullName=" + fullName
        + ", viewDefinition=" + viewDefinition
        + ", viewDependencies=" + viewDependencies
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Table", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Table {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String comment;
    @javax.annotation.Nullable String catalogName;
    @javax.annotation.Nullable String schemaName;
    @javax.annotation.Nullable String metastoreId;
    @javax.annotation.Nullable String tableType;
    @javax.annotation.Nullable String datasourceFormat;
    @javax.annotation.Nullable List<Field> columns = Collections.emptyList();
    boolean columnsIsSet;
    @javax.annotation.Nullable String storageLocation;
    @javax.annotation.Nullable String createdAt;
    @javax.annotation.Nullable String createdBy;
    @javax.annotation.Nullable String updatedAt;
    @javax.annotation.Nullable String updatedBy;
    @javax.annotation.Nullable String tableId;
    @javax.annotation.Nullable String partitionedBy;
    @javax.annotation.Nullable List<Constraint> tableConstraints = null;
    @javax.annotation.Nullable String fullName;
    @javax.annotation.Nullable String viewDefinition;
    @javax.annotation.Nullable ViewDependencies viewDependencies;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("comment")
    public void setComment(@Nullable String comment) {
      this.comment = comment;
    }
    @JsonProperty("catalog_name")
    public void setCatalogName(@Nullable String catalogName) {
      this.catalogName = catalogName;
    }
    @JsonProperty("schema_name")
    public void setSchemaName(@Nullable String schemaName) {
      this.schemaName = schemaName;
    }
    @JsonProperty("metastore_id")
    public void setMetastoreId(@Nullable String metastoreId) {
      this.metastoreId = metastoreId;
    }
    @JsonProperty("table_type")
    public void setTableType(@Nullable String tableType) {
      this.tableType = tableType;
    }
    @JsonProperty("data_source_format")
    public void setDatasourceFormat(@Nullable String datasourceFormat) {
      this.datasourceFormat = datasourceFormat;
    }
    @JsonProperty("columns")
    public void setColumns(List<Field> columns) {
      this.columns = columns;
      this.columnsIsSet = null != columns;
    }
    @JsonProperty("storage_location")
    public void setStorageLocation(@Nullable String storageLocation) {
      this.storageLocation = storageLocation;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("created_by")
    public void setCreatedBy(@Nullable String createdBy) {
      this.createdBy = createdBy;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("updated_by")
    public void setUpdatedBy(@Nullable String updatedBy) {
      this.updatedBy = updatedBy;
    }
    @JsonProperty("table_id")
    public void setTableId(@Nullable String tableId) {
      this.tableId = tableId;
    }
    @JsonProperty("partitionedBy")
    public void setPartitionedBy(@Nullable String partitionedBy) {
      this.partitionedBy = partitionedBy;
    }
    @JsonProperty("table_constraints")
    public void setTableConstraints(@Nullable List<Constraint> tableConstraints) {
      this.tableConstraints = tableConstraints;
    }
    @JsonProperty("full_name")
    public void setFullName(@Nullable String fullName) {
      this.fullName = fullName;
    }
    @JsonProperty("view_definition")
    public void setViewDefinition(@Nullable String viewDefinition) {
      this.viewDefinition = viewDefinition;
    }
    @JsonProperty("view_dependencies")
    public void setViewDependencies(@Nullable ViewDependencies viewDependencies) {
      this.viewDependencies = viewDependencies;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getComment() { throw new UnsupportedOperationException(); }
    @Override
    public String getCatalogName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSchemaName() { throw new UnsupportedOperationException(); }
    @Override
    public String getMetastoreId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatasourceFormat() { throw new UnsupportedOperationException(); }
    @Override
    public List<Field> getColumns() { throw new UnsupportedOperationException(); }
    @Override
    public String getStorageLocation() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedBy() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedBy() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableId() { throw new UnsupportedOperationException(); }
    @Override
    public String getPartitionedBy() { throw new UnsupportedOperationException(); }
    @Override
    public List<Constraint> getTableConstraints() { throw new UnsupportedOperationException(); }
    @Override
    public String getFullName() { throw new UnsupportedOperationException(); }
    @Override
    public String getViewDefinition() { throw new UnsupportedOperationException(); }
    @Override
    public ViewDependencies getViewDependencies() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTable fromJson(Json json) {
    ImmutableTable.Builder builder = ImmutableTable.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.catalogName != null) {
      builder.catalogName(json.catalogName);
    }
    if (json.schemaName != null) {
      builder.schemaName(json.schemaName);
    }
    if (json.metastoreId != null) {
      builder.metastoreId(json.metastoreId);
    }
    if (json.tableType != null) {
      builder.tableType(json.tableType);
    }
    if (json.datasourceFormat != null) {
      builder.datasourceFormat(json.datasourceFormat);
    }
    if (json.columnsIsSet) {
      builder.addAllColumns(json.columns);
    }
    if (json.storageLocation != null) {
      builder.storageLocation(json.storageLocation);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.createdBy != null) {
      builder.createdBy(json.createdBy);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.updatedBy != null) {
      builder.updatedBy(json.updatedBy);
    }
    if (json.tableId != null) {
      builder.tableId(json.tableId);
    }
    if (json.partitionedBy != null) {
      builder.partitionedBy(json.partitionedBy);
    }
    if (json.tableConstraints != null) {
      builder.addAllTableConstraints(json.tableConstraints);
    }
    if (json.fullName != null) {
      builder.fullName(json.fullName);
    }
    if (json.viewDefinition != null) {
      builder.viewDefinition(json.viewDefinition);
    }
    if (json.viewDependencies != null) {
      builder.viewDependencies(json.viewDependencies);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Table} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Table instance
   */
  public static ImmutableTable copyOf(Table instance) {
    if (instance instanceof ImmutableTable) {
      return (ImmutableTable) instance;
    }
    return ImmutableTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTable ImmutableTable}.
   * <pre>
   * ImmutableTable.builder()
   *    .name(String | null) // nullable {@link Table#getName() name}
   *    .comment(String | null) // nullable {@link Table#getComment() comment}
   *    .catalogName(String | null) // nullable {@link Table#getCatalogName() catalogName}
   *    .schemaName(String | null) // nullable {@link Table#getSchemaName() schemaName}
   *    .metastoreId(String | null) // nullable {@link Table#getMetastoreId() metastoreId}
   *    .tableType(String | null) // nullable {@link Table#getTableType() tableType}
   *    .datasourceFormat(String | null) // nullable {@link Table#getDatasourceFormat() datasourceFormat}
   *    .addColumns|addAllColumns(zeenea.connector.databricks.commons.client.Field) // {@link Table#getColumns() columns} elements
   *    .storageLocation(String | null) // nullable {@link Table#getStorageLocation() storageLocation}
   *    .createdAt(String | null) // nullable {@link Table#getCreatedAt() createdAt}
   *    .createdBy(String | null) // nullable {@link Table#getCreatedBy() createdBy}
   *    .updatedAt(String | null) // nullable {@link Table#getUpdatedAt() updatedAt}
   *    .updatedBy(String | null) // nullable {@link Table#getUpdatedBy() updatedBy}
   *    .tableId(String | null) // nullable {@link Table#getTableId() tableId}
   *    .partitionedBy(String | null) // nullable {@link Table#getPartitionedBy() partitionedBy}
   *    .tableConstraints(List&amp;lt;zeenea.connector.databricks.commons.client.constraints.Constraint&amp;gt; | null) // nullable {@link Table#getTableConstraints() tableConstraints}
   *    .fullName(String | null) // nullable {@link Table#getFullName() fullName}
   *    .viewDefinition(String | null) // nullable {@link Table#getViewDefinition() viewDefinition}
   *    .viewDependencies(zeenea.connector.databricks.commons.client.ViewDependencies | null) // nullable {@link Table#getViewDependencies() viewDependencies}
   *    .build();
   * </pre>
   * @return A new ImmutableTable builder
   */
  public static ImmutableTable.Builder builder() {
    return new ImmutableTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTable ImmutableTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_COLUMNS = 0x1L;
    private long optBits;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String comment;
    private @javax.annotation.Nullable String catalogName;
    private @javax.annotation.Nullable String schemaName;
    private @javax.annotation.Nullable String metastoreId;
    private @javax.annotation.Nullable String tableType;
    private @javax.annotation.Nullable String datasourceFormat;
    private List<Field> columns = new ArrayList<Field>();
    private @javax.annotation.Nullable String storageLocation;
    private @javax.annotation.Nullable String createdAt;
    private @javax.annotation.Nullable String createdBy;
    private @javax.annotation.Nullable String updatedAt;
    private @javax.annotation.Nullable String updatedBy;
    private @javax.annotation.Nullable String tableId;
    private @javax.annotation.Nullable String partitionedBy;
    private List<Constraint> tableConstraints = null;
    private @javax.annotation.Nullable String fullName;
    private @javax.annotation.Nullable String viewDefinition;
    private @javax.annotation.Nullable ViewDependencies viewDependencies;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Table} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Table instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String commentValue = instance.getComment();
      if (commentValue != null) {
        comment(commentValue);
      }
      @Nullable String catalogNameValue = instance.getCatalogName();
      if (catalogNameValue != null) {
        catalogName(catalogNameValue);
      }
      @Nullable String schemaNameValue = instance.getSchemaName();
      if (schemaNameValue != null) {
        schemaName(schemaNameValue);
      }
      @Nullable String metastoreIdValue = instance.getMetastoreId();
      if (metastoreIdValue != null) {
        metastoreId(metastoreIdValue);
      }
      @Nullable String tableTypeValue = instance.getTableType();
      if (tableTypeValue != null) {
        tableType(tableTypeValue);
      }
      @Nullable String datasourceFormatValue = instance.getDatasourceFormat();
      if (datasourceFormatValue != null) {
        datasourceFormat(datasourceFormatValue);
      }
      addAllColumns(instance.getColumns());
      @Nullable String storageLocationValue = instance.getStorageLocation();
      if (storageLocationValue != null) {
        storageLocation(storageLocationValue);
      }
      @Nullable String createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      @Nullable String createdByValue = instance.getCreatedBy();
      if (createdByValue != null) {
        createdBy(createdByValue);
      }
      @Nullable String updatedAtValue = instance.getUpdatedAt();
      if (updatedAtValue != null) {
        updatedAt(updatedAtValue);
      }
      @Nullable String updatedByValue = instance.getUpdatedBy();
      if (updatedByValue != null) {
        updatedBy(updatedByValue);
      }
      @Nullable String tableIdValue = instance.getTableId();
      if (tableIdValue != null) {
        tableId(tableIdValue);
      }
      @Nullable String partitionedByValue = instance.getPartitionedBy();
      if (partitionedByValue != null) {
        partitionedBy(partitionedByValue);
      }
      @Nullable List<Constraint> tableConstraintsValue = instance.getTableConstraints();
      if (tableConstraintsValue != null) {
        addAllTableConstraints(tableConstraintsValue);
      }
      @Nullable String fullNameValue = instance.getFullName();
      if (fullNameValue != null) {
        fullName(fullNameValue);
      }
      @Nullable String viewDefinitionValue = instance.getViewDefinition();
      if (viewDefinitionValue != null) {
        viewDefinition(viewDefinitionValue);
      }
      @Nullable ViewDependencies viewDependenciesValue = instance.getViewDependencies();
      if (viewDependenciesValue != null) {
        viewDependencies(viewDependenciesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getComment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("comment")
    public final Builder comment(@Nullable String comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getCatalogName() catalogName} attribute.
     * @param catalogName The value for catalogName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("catalog_name")
    public final Builder catalogName(@Nullable String catalogName) {
      this.catalogName = catalogName;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getSchemaName() schemaName} attribute.
     * @param schemaName The value for schemaName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema_name")
    public final Builder schemaName(@Nullable String schemaName) {
      this.schemaName = schemaName;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getMetastoreId() metastoreId} attribute.
     * @param metastoreId The value for metastoreId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metastore_id")
    public final Builder metastoreId(@Nullable String metastoreId) {
      this.metastoreId = metastoreId;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getTableType() tableType} attribute.
     * @param tableType The value for tableType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_type")
    public final Builder tableType(@Nullable String tableType) {
      this.tableType = tableType;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getDatasourceFormat() datasourceFormat} attribute.
     * @param datasourceFormat The value for datasourceFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data_source_format")
    public final Builder datasourceFormat(@Nullable String datasourceFormat) {
      this.datasourceFormat = datasourceFormat;
      return this;
    }

    /**
     * Adds one element to {@link Table#getColumns() columns} list.
     * @param element A columns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addColumns(Field element) {
      this.columns.add(Objects.requireNonNull(element, "columns element"));
      optBits |= OPT_BIT_COLUMNS;
      return this;
    }

    /**
     * Adds elements to {@link Table#getColumns() columns} list.
     * @param elements An array of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addColumns(Field... elements) {
      for (Field element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      optBits |= OPT_BIT_COLUMNS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Table#getColumns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("columns")
    public final Builder columns(Iterable<? extends Field> elements) {
      this.columns.clear();
      return addAllColumns(elements);
    }

    /**
     * Adds elements to {@link Table#getColumns() columns} list.
     * @param elements An iterable of columns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllColumns(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.columns.add(Objects.requireNonNull(element, "columns element"));
      }
      optBits |= OPT_BIT_COLUMNS;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getStorageLocation() storageLocation} attribute.
     * @param storageLocation The value for storageLocation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("storage_location")
    public final Builder storageLocation(@Nullable String storageLocation) {
      this.storageLocation = storageLocation;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getCreatedBy() createdBy} attribute.
     * @param createdBy The value for createdBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_by")
    public final Builder createdBy(@Nullable String createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getUpdatedBy() updatedBy} attribute.
     * @param updatedBy The value for updatedBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_by")
    public final Builder updatedBy(@Nullable String updatedBy) {
      this.updatedBy = updatedBy;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getTableId() tableId} attribute.
     * @param tableId The value for tableId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_id")
    public final Builder tableId(@Nullable String tableId) {
      this.tableId = tableId;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getPartitionedBy() partitionedBy} attribute.
     * @param partitionedBy The value for partitionedBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("partitionedBy")
    public final Builder partitionedBy(@Nullable String partitionedBy) {
      this.partitionedBy = partitionedBy;
      return this;
    }

    /**
     * Adds one element to {@link Table#getTableConstraints() tableConstraints} list.
     * @param element A tableConstraints element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTableConstraints(Constraint element) {
      if (this.tableConstraints == null) {
        this.tableConstraints = new ArrayList<Constraint>();
      }
      this.tableConstraints.add(Objects.requireNonNull(element, "tableConstraints element"));
      return this;
    }

    /**
     * Adds elements to {@link Table#getTableConstraints() tableConstraints} list.
     * @param elements An array of tableConstraints elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTableConstraints(Constraint... elements) {
      if (this.tableConstraints == null) {
        this.tableConstraints = new ArrayList<Constraint>();
      }
      for (Constraint element : elements) {
        this.tableConstraints.add(Objects.requireNonNull(element, "tableConstraints element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Table#getTableConstraints() tableConstraints} list.
     * @param elements An iterable of tableConstraints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_constraints")
    public final Builder tableConstraints(@Nullable Iterable<? extends Constraint> elements) {
      if (elements == null) {
        this.tableConstraints = null;
        return this;
      }
      this.tableConstraints = new ArrayList<Constraint>();
      return addAllTableConstraints(elements);
    }

    /**
     * Adds elements to {@link Table#getTableConstraints() tableConstraints} list.
     * @param elements An iterable of tableConstraints elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTableConstraints(Iterable<? extends Constraint> elements) {
      Objects.requireNonNull(elements, "tableConstraints element");
      if (this.tableConstraints == null) {
        this.tableConstraints = new ArrayList<Constraint>();
      }
      for (Constraint element : elements) {
        this.tableConstraints.add(Objects.requireNonNull(element, "tableConstraints element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getFullName() fullName} attribute.
     * @param fullName The value for fullName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("full_name")
    public final Builder fullName(@Nullable String fullName) {
      this.fullName = fullName;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getViewDefinition() viewDefinition} attribute.
     * @param viewDefinition The value for viewDefinition (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("view_definition")
    public final Builder viewDefinition(@Nullable String viewDefinition) {
      this.viewDefinition = viewDefinition;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#getViewDependencies() viewDependencies} attribute.
     * @param viewDependencies The value for viewDependencies (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("view_dependencies")
    public final Builder viewDependencies(@Nullable ViewDependencies viewDependencies) {
      this.viewDependencies = viewDependencies;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTable ImmutableTable}.
     * @return An immutable instance of Table
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTable build() {
      return new ImmutableTable(this);
    }

    private boolean columnsIsSet() {
      return (optBits & OPT_BIT_COLUMNS) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
