/*
 * Decompiled with CFR 0.152.
 */
package zeenea.common.properties;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import zeenea.common.properties.type.Type;

public final class CommonProperty {
    private final UUID uuid;
    private final String defaultName;
    @Nullable
    private final String defaultDescription;
    private final Type type;
    private final Boolean isPropagable;

    public CommonProperty(UUID uuid, String defaultName, @Nullable String defaultDescription, Type type, Boolean isPropagable) {
        this.uuid = uuid;
        this.defaultName = defaultName;
        this.defaultDescription = defaultDescription;
        this.type = type;
        this.isPropagable = isPropagable;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String defaultName() {
        return this.defaultName;
    }

    @Nullable
    public String defaultDescription() {
        return this.defaultDescription;
    }

    public Optional<String> getDefaultDescription() {
        return Optional.ofNullable(this.defaultDescription);
    }

    public Type type() {
        return this.type;
    }

    public Boolean getIsPropagable() {
        return this.isPropagable;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CommonProperty that = (CommonProperty)obj;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.defaultName, that.defaultName) && Objects.equals(this.defaultDescription, that.defaultDescription) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.isPropagable, that.isPropagable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.defaultName, this.defaultDescription, this.type, this.isPropagable});
    }

    public String toString() {
        return "CommonProperty[uuid=" + this.uuid + ", defaultName=" + this.defaultName + ", defaultDescription=" + this.defaultDescription + ", type=" + this.type + ", isPropagable=" + this.isPropagable + "]";
    }
}

