/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.databind.JavaType;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hc.core5.http.HttpEntity;
import zeenea.connector.commons.http.client.CsvDeserializationException;
import zeenea.connector.commons.http.client.CsvSerealizationException;
import zeenea.connector.commons.http.client.EntityMapper;

public enum HttpCsvMapper implements EntityMapper
{
    INSTANCE;


    public static HttpCsvMapper of() {
        return INSTANCE;
    }

    public List<String[]> readEntity(HttpEntity entity, JavaType type) throws IOException {
        List list;
        block8: {
            CSVReader csvReader = new CSVReaderBuilder((Reader)new StringReader(new String(entity.getContent().readAllBytes(), StandardCharsets.UTF_8))).build();
            try {
                list = csvReader.readAll();
                if (csvReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (csvReader != null) {
                        try {
                            csvReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CsvException e) {
                    throw new CsvDeserializationException(String.format("Failed parsing CSV response : %s", e.getMessage()), e);
                }
            }
            csvReader.close();
        }
        return list;
    }

    @Override
    public <T> HttpEntity writeAsEntity(T content) {
        throw new UnsupportedOperationException("Writing CSV data is not supported");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> String prettyPrint(T o) {
        if (!(o instanceof List) || ((List)o).get(0) instanceof String[]) {
            throw new IllegalArgumentException("Input must be a List of String arrays");
        }
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (CSVWriter csvWriter = new CSVWriter((Writer)stringWriter);){
                csvWriter.writeAll((List)o);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new CsvSerealizationException(String.format("Failed parsing csv for printing: %s", e.getMessage()), e);
        }
    }
}

