/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.db;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.util.StringUtil;

public final class DbTable
implements Comparable<DbTable> {
    public static final Comparator<DbTable> COMPARATOR = Comparator.comparing(DbTable::engine).thenComparing(DbTable::host, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DbTable::port, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DbTable::database, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DbTable::schema, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(DbTable::table, Comparator.nullsFirst(Comparator.naturalOrder()));
    @NotNull
    private final DbEngine engine;
    @Nullable
    private final String host;
    @Nullable
    private final Integer port;
    @Nullable
    private final List<String> prefix;
    @Nullable
    private final String database;
    @Nullable
    private final String schema;
    @Nullable
    private final String table;

    private DbTable(Builder builder) {
        this.engine = Objects.requireNonNull(builder.engine);
        this.host = this.engine.normalizeHost(builder.host);
        this.port = builder.port;
        this.prefix = builder.prefix;
        this.database = builder.database;
        this.schema = builder.schema;
        this.table = builder.table;
    }

    public static Builder builder(DbEngine engine) {
        return DbTable.builder(engine, true);
    }

    public static Builder builder(DbEngine engine, boolean normalize) {
        return new Builder(engine, normalize);
    }

    public DbEngine engine() {
        return this.engine;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port != null ? this.port.intValue() : this.engine.defaultPort();
    }

    public List<String> prefix() {
        return this.prefix != null ? this.prefix : this.engine.defaultPrefix();
    }

    public String database() {
        return this.database;
    }

    public String schema() {
        return this.schema;
    }

    public String table() {
        return this.table;
    }

    @Override
    public int compareTo(@NotNull DbTable that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbTable dbTable = (DbTable)o;
        return this.engine == dbTable.engine && Objects.equals(this.host, dbTable.host) && Objects.equals(this.port, dbTable.port) && Objects.equals(this.prefix, dbTable.prefix) && Objects.equals(this.database, dbTable.database) && Objects.equals(this.schema, dbTable.schema) && Objects.equals(this.table, dbTable.table);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.engine, this.host, this.port, this.prefix, this.database, this.schema, this.table});
    }

    public static final class Builder {
        @NotNull
        private final DbEngine engine;
        @Nullable
        private String host;
        @Nullable
        private List<String> prefix;
        @Nullable
        private Integer port;
        @Nullable
        private String database;
        @Nullable
        private String schema;
        @Nullable
        private String table;
        private final boolean normalize;

        public Builder(@NotNull DbEngine engine, boolean normalize) {
            this.engine = Objects.requireNonNull(engine);
            this.normalize = normalize;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port <= 0 ? null : Integer.valueOf(port);
            return this;
        }

        public Builder port(Integer port) {
            this.port = port != null && port <= 0 ? null : port;
            return this;
        }

        public Builder prefix(List<String> prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder prefix(String ... prefix) {
            this.prefix = List.of(prefix);
            return this;
        }

        public Builder database(String database) {
            this.database = StringUtil.emptyToNull(this.normalize ? this.engine.unescape(database) : database);
            return this;
        }

        public Builder schema(String schema) {
            this.schema = StringUtil.emptyToNull(this.normalize ? this.engine.unescape(schema) : schema);
            return this;
        }

        public Builder table(String table) {
            this.table = StringUtil.emptyToNull(this.normalize ? this.engine.unescape(table) : table);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder parse(String text) {
            if (text == null || text.isEmpty()) {
                return this;
            }
            ArrayList<String> parts = new ArrayList<String>();
            ParseState state = ParseState.INIT;
            int begin = 0;
            int pos = 0;
            int len = text.length();
            block45: while (true) {
                int c = pos >= len ? -1 : (int)text.charAt(pos);
                block0 : switch (state) {
                    case INIT: {
                        begin = pos;
                        switch (c) {
                            case -1: {
                                parts.add("");
                                break block45;
                            }
                            case 46: {
                                parts.add("");
                                break;
                            }
                            case 34: {
                                state = ParseState.DOUBLE_QUOTED;
                                break;
                            }
                            case 91: {
                                state = ParseState.BRACKET_QUOTED;
                                break;
                            }
                            case 96: {
                                state = ParseState.BACKTICK_QUOTED;
                                break;
                            }
                            case 47: {
                                if (this.engine == DbEngine.TDV) break;
                                state = ParseState.UNQUOTED;
                                break;
                            }
                            default: {
                                state = ParseState.UNQUOTED;
                                break;
                            }
                        }
                        break;
                    }
                    case UNQUOTED: {
                        switch (c) {
                            case -1: {
                                parts.add(text.substring(begin, len));
                                break block45;
                            }
                            case 46: {
                                parts.add(text.substring(begin, pos));
                                state = ParseState.INIT;
                                break;
                            }
                            case 47: {
                                if (this.engine == DbEngine.TDV) {
                                    parts.add(text.substring(begin, pos));
                                    state = ParseState.INIT;
                                    break;
                                }
                                break block0;
                            }
                        }
                        break;
                    }
                    case DOUBLE_QUOTED: {
                        switch (c) {
                            case -1: {
                                throw new IllegalArgumentException("Unclosed double quote at " + pos + ": " + text);
                            }
                            case 34: {
                                parts.add(text.substring(begin, pos + 1));
                                state = ParseState.WAIT_DOT;
                                break block0;
                            }
                        }
                        break;
                    }
                    case BRACKET_QUOTED: {
                        switch (c) {
                            case -1: {
                                throw new IllegalArgumentException("Unclosed bracket quote at " + pos + ": " + text);
                            }
                            case 93: {
                                parts.add(text.substring(begin, pos + 1));
                                state = ParseState.WAIT_DOT;
                                break block0;
                            }
                        }
                        break;
                    }
                    case BACKTICK_QUOTED: {
                        switch (c) {
                            case -1: {
                                throw new IllegalArgumentException("Unclosed backtick quote at " + pos + ": " + text);
                            }
                            case 96: {
                                parts.add(text.substring(begin, pos + 1));
                                state = ParseState.WAIT_DOT;
                                break;
                            }
                            case 46: {
                                if (this.engine != DbEngine.BIGQUERY) break;
                                parts.add(text.substring(begin, pos) + "`");
                                begin = pos + 1;
                                state = ParseState.BQ_QUOTED;
                                break;
                            }
                        }
                        break;
                    }
                    case BQ_QUOTED: {
                        switch (c) {
                            case -1: {
                                throw new IllegalArgumentException("Unclosed backtick quote at " + pos + ": " + text);
                            }
                            case 96: {
                                parts.add("`" + text.substring(begin, pos + 1));
                                state = ParseState.WAIT_DOT;
                                break block0;
                            }
                            case 46: {
                                parts.add("`" + text.substring(begin, pos) + "`");
                                begin = pos + 1;
                                break block0;
                            }
                        }
                        break;
                    }
                    case WAIT_DOT: {
                        switch (c) {
                            case -1: {
                                break block45;
                            }
                            case 46: {
                                state = ParseState.INIT;
                                break block0;
                            }
                            case 47: {
                                if (this.engine == DbEngine.TDV) {
                                    state = ParseState.INIT;
                                    break block0;
                                }
                            }
                            default: {
                                throw new IllegalArgumentException("db_table_builder_parse_wait_dot_or_end at " + pos + " :  " + text);
                            }
                        }
                    }
                }
                ++pos;
            }
            this.setPart(parts, 1, this::table);
            this.setPart(parts, 2, this::schema);
            this.setPart(parts, 3, this::database);
            this.setPrefix(parts);
            return this;
        }

        private void setPart(ArrayList<String> parts, int i, Consumer<String> setter) {
            String value;
            int n = parts.size();
            if (n >= i && StringUtil.nonEmpty(value = parts.get(n - i))) {
                setter.accept(value);
            }
        }

        private void setPrefix(ArrayList<String> parts) {
            if (parts.size() > 3) {
                this.prefix = List.copyOf(parts.subList(0, parts.size() - 3));
            }
        }

        public DbTable build() {
            return new DbTable(this);
        }

        private static enum ParseState {
            INIT,
            UNQUOTED,
            DOUBLE_QUOTED,
            BRACKET_QUOTED,
            BACKTICK_QUOTED,
            BQ_QUOTED,
            WAIT_DOT;

        }
    }
}

