package zeenea.connector.databricks.unitycatalog.rest.client.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TableLineage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTableLineage.builder()}.
 */
@Generated(from = "TableLineage", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTableLineage
    implements TableLineage {
  private final List<LineageStream> upstreamTables;

  private ImmutableTableLineage(
      List<LineageStream> upstreamTables) {
    this.upstreamTables = upstreamTables;
  }

  /**
   * @return The value of the {@code upstreamTables} attribute
   */
  @JsonProperty("upstreams")
  @Override
  public List<LineageStream> getUpstreamTables() {
    return upstreamTables;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TableLineage#getUpstreamTables() upstreamTables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableLineage withUpstreamTables(LineageStream... elements) {
    List<LineageStream> newValue = List.of(elements);
    return new ImmutableTableLineage(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TableLineage#getUpstreamTables() upstreamTables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of upstreamTables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTableLineage withUpstreamTables(Iterable<? extends LineageStream> elements) {
    if (this.upstreamTables == elements) return this;
    List<LineageStream> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends LineageStream>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableTableLineage(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTableLineage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTableLineage
        && equalTo(0, (ImmutableTableLineage) another);
  }

  private boolean equalTo(int synthetic, ImmutableTableLineage another) {
    return upstreamTables.equals(another.upstreamTables);
  }

  /**
   * Computes a hash code from attributes: {@code upstreamTables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + upstreamTables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TableLineage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TableLineage{"
        + "upstreamTables=" + upstreamTables
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TableLineage", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements TableLineage {
    @Nullable List<LineageStream> upstreamTables = List.of();
    @JsonProperty("upstreams")
    public void setUpstreamTables(List<LineageStream> upstreamTables) {
      this.upstreamTables = upstreamTables;
    }
    @Override
    public List<LineageStream> getUpstreamTables() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTableLineage fromJson(Json json) {
    ImmutableTableLineage.Builder builder = ImmutableTableLineage.builder();
    if (json.upstreamTables != null) {
      builder.addAllUpstreamTables(json.upstreamTables);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TableLineage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TableLineage instance
   */
  public static ImmutableTableLineage copyOf(TableLineage instance) {
    if (instance instanceof ImmutableTableLineage) {
      return (ImmutableTableLineage) instance;
    }
    return ImmutableTableLineage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTableLineage ImmutableTableLineage}.
   * <pre>
   * ImmutableTableLineage.builder()
   *    .addUpstreamTables|addAllUpstreamTables(zeenea.connector.databricks.unitycatalog.rest.client.model.lineage.LineageStream) // {@link TableLineage#getUpstreamTables() upstreamTables} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTableLineage builder
   */
  public static ImmutableTableLineage.Builder builder() {
    return new ImmutableTableLineage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTableLineage ImmutableTableLineage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TableLineage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<LineageStream> upstreamTables = new ArrayList<LineageStream>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TableLineage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TableLineage instance) {
      Objects.requireNonNull(instance, "instance");
      addAllUpstreamTables(instance.getUpstreamTables());
      return this;
    }

    /**
     * Adds one element to {@link TableLineage#getUpstreamTables() upstreamTables} list.
     * @param element A upstreamTables element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUpstreamTables(LineageStream element) {
      this.upstreamTables.add(Objects.requireNonNull(element, "upstreamTables element"));
      return this;
    }

    /**
     * Adds elements to {@link TableLineage#getUpstreamTables() upstreamTables} list.
     * @param elements An array of upstreamTables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUpstreamTables(LineageStream... elements) {
      for (LineageStream element : elements) {
        this.upstreamTables.add(Objects.requireNonNull(element, "upstreamTables element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TableLineage#getUpstreamTables() upstreamTables} list.
     * @param elements An iterable of upstreamTables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("upstreams")
    public final Builder upstreamTables(Iterable<? extends LineageStream> elements) {
      this.upstreamTables.clear();
      return addAllUpstreamTables(elements);
    }

    /**
     * Adds elements to {@link TableLineage#getUpstreamTables() upstreamTables} list.
     * @param elements An iterable of upstreamTables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUpstreamTables(Iterable<? extends LineageStream> elements) {
      for (LineageStream element : elements) {
        this.upstreamTables.add(Objects.requireNonNull(element, "upstreamTables element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTableLineage ImmutableTableLineage}.
     * @return An immutable instance of TableLineage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTableLineage build() {
      return new ImmutableTableLineage(List.copyOf(upstreamTables));
    }
  }
}
