package zeenea.connector.databricks.unitycatalog.rest.client.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Column}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColumn.builder()}.
 */
@Generated(from = "Column", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableColumn
    implements Column {
  private final String name;
  private final String catalogName;
  private final String schemaName;
  private final String tableName;
  private final String tableType;

  private ImmutableColumn(
      String name,
      String catalogName,
      String schemaName,
      String tableName,
      String tableType) {
    this.name = name;
    this.catalogName = catalogName;
    this.schemaName = schemaName;
    this.tableName = tableName;
    this.tableType = tableType;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code catalogName} attribute
   */
  @JsonProperty("catalog_name")
  @Override
  public String getCatalogName() {
    return catalogName;
  }

  /**
   * @return The value of the {@code schemaName} attribute
   */
  @JsonProperty("schema_name")
  @Override
  public String getSchemaName() {
    return schemaName;
  }

  /**
   * @return The value of the {@code tableName} attribute
   */
  @JsonProperty("table_name")
  @Override
  public String getTableName() {
    return tableName;
  }

  /**
   * @return The value of the {@code tableType} attribute
   */
  @JsonProperty("table_type")
  @Override
  public String getTableType() {
    return tableType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableColumn(newValue, this.catalogName, this.schemaName, this.tableName, this.tableType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getCatalogName() catalogName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalogName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withCatalogName(String value) {
    String newValue = Objects.requireNonNull(value, "catalogName");
    if (this.catalogName.equals(newValue)) return this;
    return new ImmutableColumn(this.name, newValue, this.schemaName, this.tableName, this.tableType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getSchemaName() schemaName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withSchemaName(String value) {
    String newValue = Objects.requireNonNull(value, "schemaName");
    if (this.schemaName.equals(newValue)) return this;
    return new ImmutableColumn(this.name, this.catalogName, newValue, this.tableName, this.tableType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getTableName() tableName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withTableName(String value) {
    String newValue = Objects.requireNonNull(value, "tableName");
    if (this.tableName.equals(newValue)) return this;
    return new ImmutableColumn(this.name, this.catalogName, this.schemaName, newValue, this.tableType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Column#getTableType() tableType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColumn withTableType(String value) {
    String newValue = Objects.requireNonNull(value, "tableType");
    if (this.tableType.equals(newValue)) return this;
    return new ImmutableColumn(this.name, this.catalogName, this.schemaName, this.tableName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColumn} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColumn
        && equalTo(0, (ImmutableColumn) another);
  }

  private boolean equalTo(int synthetic, ImmutableColumn another) {
    return name.equals(another.name)
        && catalogName.equals(another.catalogName)
        && schemaName.equals(another.schemaName)
        && tableName.equals(another.tableName)
        && tableType.equals(another.tableType);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code catalogName}, {@code schemaName}, {@code tableName}, {@code tableType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + catalogName.hashCode();
    h += (h << 5) + schemaName.hashCode();
    h += (h << 5) + tableName.hashCode();
    h += (h << 5) + tableType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Column} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Column{"
        + "name=" + name
        + ", catalogName=" + catalogName
        + ", schemaName=" + schemaName
        + ", tableName=" + tableName
        + ", tableType=" + tableType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Column", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Column {
    @Nullable String name;
    @Nullable String catalogName;
    @Nullable String schemaName;
    @Nullable String tableName;
    @Nullable String tableType;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("catalog_name")
    public void setCatalogName(String catalogName) {
      this.catalogName = catalogName;
    }
    @JsonProperty("schema_name")
    public void setSchemaName(String schemaName) {
      this.schemaName = schemaName;
    }
    @JsonProperty("table_name")
    public void setTableName(String tableName) {
      this.tableName = tableName;
    }
    @JsonProperty("table_type")
    public void setTableType(String tableType) {
      this.tableType = tableType;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCatalogName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSchemaName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableColumn fromJson(Json json) {
    ImmutableColumn.Builder builder = ImmutableColumn.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.catalogName != null) {
      builder.catalogName(json.catalogName);
    }
    if (json.schemaName != null) {
      builder.schemaName(json.schemaName);
    }
    if (json.tableName != null) {
      builder.tableName(json.tableName);
    }
    if (json.tableType != null) {
      builder.tableType(json.tableType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Column} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Column instance
   */
  public static ImmutableColumn copyOf(Column instance) {
    if (instance instanceof ImmutableColumn) {
      return (ImmutableColumn) instance;
    }
    return ImmutableColumn.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColumn ImmutableColumn}.
   * <pre>
   * ImmutableColumn.builder()
   *    .name(String) // required {@link Column#getName() name}
   *    .catalogName(String) // required {@link Column#getCatalogName() catalogName}
   *    .schemaName(String) // required {@link Column#getSchemaName() schemaName}
   *    .tableName(String) // required {@link Column#getTableName() tableName}
   *    .tableType(String) // required {@link Column#getTableType() tableType}
   *    .build();
   * </pre>
   * @return A new ImmutableColumn builder
   */
  public static ImmutableColumn.Builder builder() {
    return new ImmutableColumn.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColumn ImmutableColumn}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Column", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_CATALOG_NAME = 0x2L;
    private static final long INIT_BIT_SCHEMA_NAME = 0x4L;
    private static final long INIT_BIT_TABLE_NAME = 0x8L;
    private static final long INIT_BIT_TABLE_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String name;
    private @Nullable String catalogName;
    private @Nullable String schemaName;
    private @Nullable String tableName;
    private @Nullable String tableType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Column} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Column instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.catalogName(instance.getCatalogName());
      this.schemaName(instance.getSchemaName());
      this.tableName(instance.getTableName());
      this.tableType(instance.getTableType());
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getCatalogName() catalogName} attribute.
     * @param catalogName The value for catalogName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("catalog_name")
    public final Builder catalogName(String catalogName) {
      this.catalogName = Objects.requireNonNull(catalogName, "catalogName");
      initBits &= ~INIT_BIT_CATALOG_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getSchemaName() schemaName} attribute.
     * @param schemaName The value for schemaName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema_name")
    public final Builder schemaName(String schemaName) {
      this.schemaName = Objects.requireNonNull(schemaName, "schemaName");
      initBits &= ~INIT_BIT_SCHEMA_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getTableName() tableName} attribute.
     * @param tableName The value for tableName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_name")
    public final Builder tableName(String tableName) {
      this.tableName = Objects.requireNonNull(tableName, "tableName");
      initBits &= ~INIT_BIT_TABLE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Column#getTableType() tableType} attribute.
     * @param tableType The value for tableType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_type")
    public final Builder tableType(String tableType) {
      this.tableType = Objects.requireNonNull(tableType, "tableType");
      initBits &= ~INIT_BIT_TABLE_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColumn ImmutableColumn}.
     * @return An immutable instance of Column
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColumn build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColumn(name, catalogName, schemaName, tableName, tableType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CATALOG_NAME) != 0) attributes.add("catalogName");
      if ((initBits & INIT_BIT_SCHEMA_NAME) != 0) attributes.add("schemaName");
      if ((initBits & INIT_BIT_TABLE_NAME) != 0) attributes.add("tableName");
      if ((initBits & INIT_BIT_TABLE_TYPE) != 0) attributes.add("tableType");
      return "Cannot build Column, some of required attributes are not set " + attributes;
    }
  }
}
