package zeenea.connector.databricks.unitycatalog.rest.client.model.fields;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link StructFieldType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStructFieldType.builder()}.
 */
@Generated(from = "StructFieldType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableStructFieldType
    implements StructFieldType {
  private final @Nullable String description;
  private final String type;
  private final @Nullable List<JsonField> fields;

  private ImmutableStructFieldType(
      @Nullable String description,
      String type,
      @Nullable List<JsonField> fields) {
    this.description = description;
    this.type = type;
    this.fields = fields;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty("fields")
  @Override
  public @Nullable List<JsonField> getFields() {
    return fields;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StructFieldType#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStructFieldType withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableStructFieldType(value, this.type, this.fields);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StructFieldType#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStructFieldType withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableStructFieldType(this.description, newValue, this.fields);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StructFieldType#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStructFieldType withFields(@Nullable JsonField... elements) {
    if (elements == null) {
      return new ImmutableStructFieldType(this.description, this.type, null);
    }
    List<JsonField> newValue = List.of(elements);
    return new ImmutableStructFieldType(this.description, this.type, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StructFieldType#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStructFieldType withFields(@Nullable Iterable<? extends JsonField> elements) {
    if (this.fields == elements) return this;
    @Nullable List<JsonField> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends JsonField>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableStructFieldType(this.description, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStructFieldType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStructFieldType
        && equalTo(0, (ImmutableStructFieldType) another);
  }

  private boolean equalTo(int synthetic, ImmutableStructFieldType another) {
    return Objects.equals(description, another.description)
        && type.equals(another.type)
        && Objects.equals(fields, another.fields);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code type}, {@code fields}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(fields);
    return h;
  }

  /**
   * Prints the immutable value {@code StructFieldType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StructFieldType{"
        + "description=" + description
        + ", type=" + type
        + ", fields=" + fields
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StructFieldType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements StructFieldType {
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable List<JsonField> fields = null;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("fields")
    public void setFields(@Nullable List<JsonField> fields) {
      this.fields = fields;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<JsonField> getFields() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStructFieldType fromJson(Json json) {
    ImmutableStructFieldType.Builder builder = ImmutableStructFieldType.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.fields != null) {
      builder.addAllFields(json.fields);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StructFieldType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StructFieldType instance
   */
  public static ImmutableStructFieldType copyOf(StructFieldType instance) {
    if (instance instanceof ImmutableStructFieldType) {
      return (ImmutableStructFieldType) instance;
    }
    return ImmutableStructFieldType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStructFieldType ImmutableStructFieldType}.
   * <pre>
   * ImmutableStructFieldType.builder()
   *    .description(String | null) // nullable {@link StructFieldType#getDescription() description}
   *    .type(String) // required {@link StructFieldType#getType() type}
   *    .fields(List&amp;lt;zeenea.connector.databricks.unitycatalog.rest.client.model.fields.JsonField&amp;gt; | null) // nullable {@link StructFieldType#getFields() fields}
   *    .build();
   * </pre>
   * @return A new ImmutableStructFieldType builder
   */
  public static ImmutableStructFieldType.Builder builder() {
    return new ImmutableStructFieldType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStructFieldType ImmutableStructFieldType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StructFieldType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String type;
    private List<JsonField> fields = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.StructFieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StructFieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof FieldType) {
        FieldType instance = (FieldType) object;
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof StructFieldType) {
        StructFieldType instance = (StructFieldType) object;
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        @Nullable List<JsonField> fieldsValue = instance.getFields();
        if (fieldsValue != null) {
          addAllFields(fieldsValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link StructFieldType#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link StructFieldType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link StructFieldType#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(JsonField element) {
      if (this.fields == null) {
        this.fields = new ArrayList<JsonField>();
      }
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link StructFieldType#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(JsonField... elements) {
      if (this.fields == null) {
        this.fields = new ArrayList<JsonField>();
      }
      for (JsonField element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StructFieldType#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fields")
    public final Builder fields(@Nullable Iterable<? extends JsonField> elements) {
      if (elements == null) {
        this.fields = null;
        return this;
      }
      this.fields = new ArrayList<JsonField>();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link StructFieldType#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFields(Iterable<? extends JsonField> elements) {
      Objects.requireNonNull(elements, "fields element");
      if (this.fields == null) {
        this.fields = new ArrayList<JsonField>();
      }
      for (JsonField element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableStructFieldType ImmutableStructFieldType}.
     * @return An immutable instance of StructFieldType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStructFieldType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStructFieldType(description, type, fields == null ? null : List.copyOf(fields));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build StructFieldType, some of required attributes are not set " + attributes;
    }
  }
}
