package zeenea.connector.databricks.unitycatalog.rest.client.model.fields;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link SimpleFieldType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSimpleFieldType.builder()}.
 */
@Generated(from = "SimpleFieldType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableSimpleFieldType
    implements SimpleFieldType {
  private final @Nullable String description;
  private final String value;

  private ImmutableSimpleFieldType(@Nullable String description, String value) {
    this.description = description;
    this.value = value;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimpleFieldType#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimpleFieldType withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableSimpleFieldType(value, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimpleFieldType#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimpleFieldType withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableSimpleFieldType(this.description, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSimpleFieldType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSimpleFieldType
        && equalTo(0, (ImmutableSimpleFieldType) another);
  }

  private boolean equalTo(int synthetic, ImmutableSimpleFieldType another) {
    return Objects.equals(description, another.description)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SimpleFieldType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SimpleFieldType{"
        + "description=" + description
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SimpleFieldType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements SimpleFieldType {
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String value;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSimpleFieldType fromJson(Json json) {
    ImmutableSimpleFieldType.Builder builder = ImmutableSimpleFieldType.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SimpleFieldType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SimpleFieldType instance
   */
  public static ImmutableSimpleFieldType copyOf(SimpleFieldType instance) {
    if (instance instanceof ImmutableSimpleFieldType) {
      return (ImmutableSimpleFieldType) instance;
    }
    return ImmutableSimpleFieldType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSimpleFieldType ImmutableSimpleFieldType}.
   * <pre>
   * ImmutableSimpleFieldType.builder()
   *    .description(String | null) // nullable {@link SimpleFieldType#getDescription() description}
   *    .value(String) // required {@link SimpleFieldType#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableSimpleFieldType builder
   */
  public static ImmutableSimpleFieldType.Builder builder() {
    return new ImmutableSimpleFieldType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSimpleFieldType ImmutableSimpleFieldType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SimpleFieldType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.SimpleFieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SimpleFieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof FieldType) {
        FieldType instance = (FieldType) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof SimpleFieldType) {
        SimpleFieldType instance = (SimpleFieldType) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
        this.value(instance.getValue());
      }
    }

    /**
     * Initializes the value for the {@link SimpleFieldType#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link SimpleFieldType#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSimpleFieldType ImmutableSimpleFieldType}.
     * @return An immutable instance of SimpleFieldType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSimpleFieldType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSimpleFieldType(description, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build SimpleFieldType, some of required attributes are not set " + attributes;
    }
  }
}
