package zeenea.connector.databricks.unitycatalog.rest.client.model.fields;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link MapFieldType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMapFieldType.builder()}.
 */
@Generated(from = "MapFieldType", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableMapFieldType
    implements MapFieldType {
  private final String type;
  private final @Nullable String description;
  private final FieldType keyType;
  private final boolean valueContainsNull;
  private final FieldType valueType;

  private ImmutableMapFieldType(
      String type,
      @Nullable String description,
      FieldType keyType,
      boolean valueContainsNull,
      FieldType valueType) {
    this.type = type;
    this.description = description;
    this.keyType = keyType;
    this.valueContainsNull = valueContainsNull;
    this.valueType = valueType;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code keyType} attribute
   */
  @JsonProperty("keyType")
  @Override
  public FieldType getKeyType() {
    return keyType;
  }

  /**
   * @return The value of the {@code valueContainsNull} attribute
   */
  @JsonProperty("valueContainsNull")
  @Override
  public boolean isValueContainsNull() {
    return valueContainsNull;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @JsonProperty("valueType")
  @Override
  public FieldType getValueType() {
    return valueType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapFieldType#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapFieldType withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableMapFieldType(newValue, this.description, this.keyType, this.valueContainsNull, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapFieldType#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapFieldType withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableMapFieldType(this.type, value, this.keyType, this.valueContainsNull, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapFieldType#getKeyType() keyType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapFieldType withKeyType(FieldType value) {
    if (this.keyType == value) return this;
    FieldType newValue = Objects.requireNonNull(value, "keyType");
    return new ImmutableMapFieldType(this.type, this.description, newValue, this.valueContainsNull, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapFieldType#isValueContainsNull() valueContainsNull} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueContainsNull
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapFieldType withValueContainsNull(boolean value) {
    if (this.valueContainsNull == value) return this;
    return new ImmutableMapFieldType(this.type, this.description, this.keyType, value, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapFieldType#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapFieldType withValueType(FieldType value) {
    if (this.valueType == value) return this;
    FieldType newValue = Objects.requireNonNull(value, "valueType");
    return new ImmutableMapFieldType(this.type, this.description, this.keyType, this.valueContainsNull, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMapFieldType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMapFieldType
        && equalTo(0, (ImmutableMapFieldType) another);
  }

  private boolean equalTo(int synthetic, ImmutableMapFieldType another) {
    return type.equals(another.type)
        && Objects.equals(description, another.description)
        && keyType.equals(another.keyType)
        && valueContainsNull == another.valueContainsNull
        && valueType.equals(another.valueType);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code description}, {@code keyType}, {@code valueContainsNull}, {@code valueType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + keyType.hashCode();
    h += (h << 5) + Boolean.hashCode(valueContainsNull);
    h += (h << 5) + valueType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MapFieldType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapFieldType{"
        + "type=" + type
        + ", description=" + description
        + ", keyType=" + keyType
        + ", valueContainsNull=" + valueContainsNull
        + ", valueType=" + valueType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MapFieldType", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements MapFieldType {
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable FieldType keyType;
    boolean valueContainsNull;
    boolean valueContainsNullIsSet;
    @javax.annotation.Nullable FieldType valueType;
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("keyType")
    public void setKeyType(FieldType keyType) {
      this.keyType = keyType;
    }
    @JsonProperty("valueContainsNull")
    public void setValueContainsNull(boolean valueContainsNull) {
      this.valueContainsNull = valueContainsNull;
      this.valueContainsNullIsSet = true;
    }
    @JsonProperty("valueType")
    public void setValueType(FieldType valueType) {
      this.valueType = valueType;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public FieldType getKeyType() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isValueContainsNull() { throw new UnsupportedOperationException(); }
    @Override
    public FieldType getValueType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMapFieldType fromJson(Json json) {
    ImmutableMapFieldType.Builder builder = ImmutableMapFieldType.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.keyType != null) {
      builder.keyType(json.keyType);
    }
    if (json.valueContainsNullIsSet) {
      builder.valueContainsNull(json.valueContainsNull);
    }
    if (json.valueType != null) {
      builder.valueType(json.valueType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MapFieldType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MapFieldType instance
   */
  public static ImmutableMapFieldType copyOf(MapFieldType instance) {
    if (instance instanceof ImmutableMapFieldType) {
      return (ImmutableMapFieldType) instance;
    }
    return ImmutableMapFieldType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMapFieldType ImmutableMapFieldType}.
   * <pre>
   * ImmutableMapFieldType.builder()
   *    .type(String) // required {@link MapFieldType#getType() type}
   *    .description(String | null) // nullable {@link MapFieldType#getDescription() description}
   *    .keyType(zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType) // required {@link MapFieldType#getKeyType() keyType}
   *    .valueContainsNull(boolean) // required {@link MapFieldType#isValueContainsNull() valueContainsNull}
   *    .valueType(zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType) // required {@link MapFieldType#getValueType() valueType}
   *    .build();
   * </pre>
   * @return A new ImmutableMapFieldType builder
   */
  public static ImmutableMapFieldType.Builder builder() {
    return new ImmutableMapFieldType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMapFieldType ImmutableMapFieldType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MapFieldType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_KEY_TYPE = 0x2L;
    private static final long INIT_BIT_VALUE_CONTAINS_NULL = 0x4L;
    private static final long INIT_BIT_VALUE_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable FieldType keyType;
    private boolean valueContainsNull;
    private @javax.annotation.Nullable FieldType valueType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.MapFieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MapFieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code zeenea.connector.databricks.unitycatalog.rest.client.model.fields.FieldType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldType instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof MapFieldType) {
        MapFieldType instance = (MapFieldType) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        this.keyType(instance.getKeyType());
        this.valueContainsNull(instance.isValueContainsNull());
        this.valueType(instance.getValueType());
      }
      if (object instanceof FieldType) {
        FieldType instance = (FieldType) object;
        if ((bits & 0x2L) == 0) {
          this.type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable String descriptionValue = instance.getDescription();
          if (descriptionValue != null) {
            description(descriptionValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link MapFieldType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link MapFieldType#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link MapFieldType#getKeyType() keyType} attribute.
     * @param keyType The value for keyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("keyType")
    public final Builder keyType(FieldType keyType) {
      this.keyType = Objects.requireNonNull(keyType, "keyType");
      initBits &= ~INIT_BIT_KEY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link MapFieldType#isValueContainsNull() valueContainsNull} attribute.
     * @param valueContainsNull The value for valueContainsNull 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueContainsNull")
    public final Builder valueContainsNull(boolean valueContainsNull) {
      this.valueContainsNull = valueContainsNull;
      initBits &= ~INIT_BIT_VALUE_CONTAINS_NULL;
      return this;
    }

    /**
     * Initializes the value for the {@link MapFieldType#getValueType() valueType} attribute.
     * @param valueType The value for valueType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueType")
    public final Builder valueType(FieldType valueType) {
      this.valueType = Objects.requireNonNull(valueType, "valueType");
      initBits &= ~INIT_BIT_VALUE_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMapFieldType ImmutableMapFieldType}.
     * @return An immutable instance of MapFieldType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMapFieldType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMapFieldType(type, description, keyType, valueContainsNull, valueType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_KEY_TYPE) != 0) attributes.add("keyType");
      if ((initBits & INIT_BIT_VALUE_CONTAINS_NULL) != 0) attributes.add("valueContainsNull");
      if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
      return "Cannot build MapFieldType, some of required attributes are not set " + attributes;
    }
  }
}
