package zeenea.connector.databricks.commons.client.constraints;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrimaryKeyConstraint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePrimaryKeyConstraint.builder()}.
 */
@Generated(from = "PrimaryKeyConstraint", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutablePrimaryKeyConstraint
    implements PrimaryKeyConstraint {
  private final String name;
  private final List<String> childColumns;

  private ImmutablePrimaryKeyConstraint() {
    this.name = null;
    this.childColumns = null;
  }

  private ImmutablePrimaryKeyConstraint(String name, List<String> childColumns) {
    this.name = name;
    this.childColumns = childColumns;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code childColumns} attribute
   */
  @JsonProperty("child_columns")
  @Override
  public List<String> getChildColumns() {
    return childColumns;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrimaryKeyConstraint#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrimaryKeyConstraint withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutablePrimaryKeyConstraint(newValue, this.childColumns);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrimaryKeyConstraint#getChildColumns() childColumns}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimaryKeyConstraint withChildColumns(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePrimaryKeyConstraint(this.name, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PrimaryKeyConstraint#getChildColumns() childColumns}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of childColumns elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePrimaryKeyConstraint withChildColumns(Iterable<String> elements) {
    if (this.childColumns == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePrimaryKeyConstraint(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrimaryKeyConstraint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrimaryKeyConstraint
        && equalTo(0, (ImmutablePrimaryKeyConstraint) another);
  }

  private boolean equalTo(int synthetic, ImmutablePrimaryKeyConstraint another) {
    return name.equals(another.name)
        && childColumns.equals(another.childColumns);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code childColumns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + childColumns.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PrimaryKeyConstraint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PrimaryKeyConstraint{"
        + "name=" + name
        + ", childColumns=" + childColumns
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PrimaryKeyConstraint", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements PrimaryKeyConstraint {
    @Nullable String name;
    @Nullable List<String> childColumns = Collections.emptyList();
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("child_columns")
    public void setChildColumns(List<String> childColumns) {
      this.childColumns = childColumns;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChildColumns() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePrimaryKeyConstraint fromJson(Json json) {
    ImmutablePrimaryKeyConstraint.Builder builder = ImmutablePrimaryKeyConstraint.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.childColumns != null) {
      builder.addAllChildColumns(json.childColumns);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PrimaryKeyConstraint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrimaryKeyConstraint instance
   */
  public static ImmutablePrimaryKeyConstraint copyOf(PrimaryKeyConstraint instance) {
    if (instance instanceof ImmutablePrimaryKeyConstraint) {
      return (ImmutablePrimaryKeyConstraint) instance;
    }
    return ImmutablePrimaryKeyConstraint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePrimaryKeyConstraint ImmutablePrimaryKeyConstraint}.
   * <pre>
   * ImmutablePrimaryKeyConstraint.builder()
   *    .name(String) // required {@link PrimaryKeyConstraint#getName() name}
   *    .addChildColumns|addAllChildColumns(String) // {@link PrimaryKeyConstraint#getChildColumns() childColumns} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePrimaryKeyConstraint builder
   */
  public static ImmutablePrimaryKeyConstraint.Builder builder() {
    return new ImmutablePrimaryKeyConstraint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePrimaryKeyConstraint ImmutablePrimaryKeyConstraint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrimaryKeyConstraint", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private List<String> childColumns = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PrimaryKeyConstraint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PrimaryKeyConstraint instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      addAllChildColumns(instance.getChildColumns());
      return this;
    }

    /**
     * Initializes the value for the {@link PrimaryKeyConstraint#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link PrimaryKeyConstraint#getChildColumns() childColumns} list.
     * @param element A childColumns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChildColumns(String element) {
      this.childColumns.add(Objects.requireNonNull(element, "childColumns element"));
      return this;
    }

    /**
     * Adds elements to {@link PrimaryKeyConstraint#getChildColumns() childColumns} list.
     * @param elements An array of childColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChildColumns(String... elements) {
      for (String element : elements) {
        this.childColumns.add(Objects.requireNonNull(element, "childColumns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PrimaryKeyConstraint#getChildColumns() childColumns} list.
     * @param elements An iterable of childColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("child_columns")
    public final Builder childColumns(Iterable<String> elements) {
      this.childColumns.clear();
      return addAllChildColumns(elements);
    }

    /**
     * Adds elements to {@link PrimaryKeyConstraint#getChildColumns() childColumns} list.
     * @param elements An iterable of childColumns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChildColumns(Iterable<String> elements) {
      for (String element : elements) {
        this.childColumns.add(Objects.requireNonNull(element, "childColumns element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutablePrimaryKeyConstraint ImmutablePrimaryKeyConstraint}.
     * @return An immutable instance of PrimaryKeyConstraint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrimaryKeyConstraint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePrimaryKeyConstraint(name, createUnmodifiableList(true, childColumns));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build PrimaryKeyConstraint, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
