package zeenea.connector.databricks.commons.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ViewDependency}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableViewDependency.builder()}.
 */
@Generated(from = "ViewDependency", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableViewDependency
    implements ViewDependency {
  private final @Nullable TableDependency table;

  private ImmutableViewDependency() {
    this.table = null;
  }

  private ImmutableViewDependency(
      @Nullable TableDependency table) {
    this.table = table;
  }

  /**
   * @return The value of the {@code table} attribute
   */
  @JsonProperty("table")
  @Override
  public @Nullable TableDependency getTable() {
    return table;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ViewDependency#getTable() table} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for table (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableViewDependency withTable(@Nullable TableDependency value) {
    if (this.table == value) return this;
    return new ImmutableViewDependency(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableViewDependency} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableViewDependency
        && equalTo(0, (ImmutableViewDependency) another);
  }

  private boolean equalTo(int synthetic, ImmutableViewDependency another) {
    return Objects.equals(table, another.table);
  }

  /**
   * Computes a hash code from attributes: {@code table}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(table);
    return h;
  }

  /**
   * Prints the immutable value {@code ViewDependency} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ViewDependency{"
        + "table=" + table
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ViewDependency", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ViewDependency {
    @javax.annotation.Nullable TableDependency table;
    @JsonProperty("table")
    public void setTable(@Nullable TableDependency table) {
      this.table = table;
    }
    @Override
    public TableDependency getTable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableViewDependency fromJson(Json json) {
    ImmutableViewDependency.Builder builder = ImmutableViewDependency.builder();
    if (json.table != null) {
      builder.table(json.table);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ViewDependency} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ViewDependency instance
   */
  public static ImmutableViewDependency copyOf(ViewDependency instance) {
    if (instance instanceof ImmutableViewDependency) {
      return (ImmutableViewDependency) instance;
    }
    return ImmutableViewDependency.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableViewDependency ImmutableViewDependency}.
   * <pre>
   * ImmutableViewDependency.builder()
   *    .table(zeenea.connector.databricks.commons.client.TableDependency | null) // nullable {@link ViewDependency#getTable() table}
   *    .build();
   * </pre>
   * @return A new ImmutableViewDependency builder
   */
  public static ImmutableViewDependency.Builder builder() {
    return new ImmutableViewDependency.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableViewDependency ImmutableViewDependency}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ViewDependency", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable TableDependency table;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ViewDependency} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ViewDependency instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable TableDependency tableValue = instance.getTable();
      if (tableValue != null) {
        table(tableValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ViewDependency#getTable() table} attribute.
     * @param table The value for table (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table")
    public final Builder table(@Nullable TableDependency table) {
      this.table = table;
      return this;
    }

    /**
     * Builds a new {@link ImmutableViewDependency ImmutableViewDependency}.
     * @return An immutable instance of ViewDependency
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableViewDependency build() {
      return new ImmutableViewDependency(table);
    }
  }
}
