package zeenea.connector.databricks.commons.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link TableDependency}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTableDependency.builder()}.
 */
@Generated(from = "TableDependency", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTableDependency
    implements TableDependency {
  private final @Nullable String tableFullName;

  private ImmutableTableDependency() {
    this.tableFullName = null;
  }

  private ImmutableTableDependency(@Nullable String tableFullName) {
    this.tableFullName = tableFullName;
  }

  /**
   * @return The value of the {@code tableFullName} attribute
   */
  @JsonProperty("table_full_name")
  @Override
  public @Nullable String getTableFullName() {
    return tableFullName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TableDependency#getTableFullName() tableFullName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableFullName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTableDependency withTableFullName(@Nullable String value) {
    if (Objects.equals(this.tableFullName, value)) return this;
    return new ImmutableTableDependency(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTableDependency} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTableDependency
        && equalTo(0, (ImmutableTableDependency) another);
  }

  private boolean equalTo(int synthetic, ImmutableTableDependency another) {
    return Objects.equals(tableFullName, another.tableFullName);
  }

  /**
   * Computes a hash code from attributes: {@code tableFullName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tableFullName);
    return h;
  }

  /**
   * Prints the immutable value {@code TableDependency} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TableDependency{"
        + "tableFullName=" + tableFullName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TableDependency", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TableDependency {
    @javax.annotation.Nullable String tableFullName;
    @JsonProperty("table_full_name")
    public void setTableFullName(@Nullable String tableFullName) {
      this.tableFullName = tableFullName;
    }
    @Override
    public String getTableFullName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTableDependency fromJson(Json json) {
    ImmutableTableDependency.Builder builder = ImmutableTableDependency.builder();
    if (json.tableFullName != null) {
      builder.tableFullName(json.tableFullName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TableDependency} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TableDependency instance
   */
  public static ImmutableTableDependency copyOf(TableDependency instance) {
    if (instance instanceof ImmutableTableDependency) {
      return (ImmutableTableDependency) instance;
    }
    return ImmutableTableDependency.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTableDependency ImmutableTableDependency}.
   * <pre>
   * ImmutableTableDependency.builder()
   *    .tableFullName(String | null) // nullable {@link TableDependency#getTableFullName() tableFullName}
   *    .build();
   * </pre>
   * @return A new ImmutableTableDependency builder
   */
  public static ImmutableTableDependency.Builder builder() {
    return new ImmutableTableDependency.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTableDependency ImmutableTableDependency}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TableDependency", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String tableFullName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TableDependency} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TableDependency instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String tableFullNameValue = instance.getTableFullName();
      if (tableFullNameValue != null) {
        tableFullName(tableFullNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TableDependency#getTableFullName() tableFullName} attribute.
     * @param tableFullName The value for tableFullName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table_full_name")
    public final Builder tableFullName(@Nullable String tableFullName) {
      this.tableFullName = tableFullName;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTableDependency ImmutableTableDependency}.
     * @return An immutable instance of TableDependency
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTableDependency build() {
      return new ImmutableTableDependency(tableFullName);
    }
  }
}
