package zeenea.connector.databricks.commons.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Field}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableField.builder()}.
 */
@Generated(from = "Field", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableField implements Field {
  private final String name;
  private final @Nullable String comment;
  private final String typeName;
  private final int position;
  private final boolean nullable;
  private final @Nullable String typeJson;
  private final @Nullable String typePrecision;

  private ImmutableField(
      String name,
      @Nullable String comment,
      String typeName,
      int position,
      boolean nullable,
      @Nullable String typeJson,
      @Nullable String typePrecision) {
    this.name = name;
    this.comment = comment;
    this.typeName = typeName;
    this.position = position;
    this.nullable = nullable;
    this.typeJson = typeJson;
    this.typePrecision = typePrecision;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("comment")
  @Override
  public @Nullable String getComment() {
    return comment;
  }

  /**
   * @return The value of the {@code typeName} attribute
   */
  @JsonProperty("type_name")
  @Override
  public String getTypeName() {
    return typeName;
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @JsonProperty("position")
  @Override
  public int getPosition() {
    return position;
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @JsonProperty("nullable")
  @Override
  public boolean isNullable() {
    return nullable;
  }

  /**
   * @return The value of the {@code typeJson} attribute
   */
  @JsonProperty("type_json")
  @Override
  public @Nullable String getTypeJson() {
    return typeJson;
  }

  /**
   * @return The value of the {@code typePrecision} attribute
   */
  @JsonProperty("type_precision")
  @Override
  public @Nullable String getTypePrecision() {
    return typePrecision;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableField(
        newValue,
        this.comment,
        this.typeName,
        this.position,
        this.nullable,
        this.typeJson,
        this.typePrecision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getComment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withComment(@Nullable String value) {
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableField(
        this.name,
        value,
        this.typeName,
        this.position,
        this.nullable,
        this.typeJson,
        this.typePrecision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getTypeName() typeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withTypeName(String value) {
    String newValue = Objects.requireNonNull(value, "typeName");
    if (this.typeName.equals(newValue)) return this;
    return new ImmutableField(
        this.name,
        this.comment,
        newValue,
        this.position,
        this.nullable,
        this.typeJson,
        this.typePrecision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getPosition() position} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withPosition(int value) {
    if (this.position == value) return this;
    return new ImmutableField(this.name, this.comment, this.typeName, value, this.nullable, this.typeJson, this.typePrecision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#isNullable() nullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withNullable(boolean value) {
    if (this.nullable == value) return this;
    return new ImmutableField(this.name, this.comment, this.typeName, this.position, value, this.typeJson, this.typePrecision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getTypeJson() typeJson} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeJson (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withTypeJson(@Nullable String value) {
    if (Objects.equals(this.typeJson, value)) return this;
    return new ImmutableField(this.name, this.comment, this.typeName, this.position, this.nullable, value, this.typePrecision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getTypePrecision() typePrecision} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typePrecision (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withTypePrecision(@Nullable String value) {
    if (Objects.equals(this.typePrecision, value)) return this;
    return new ImmutableField(this.name, this.comment, this.typeName, this.position, this.nullable, this.typeJson, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableField
        && equalTo(0, (ImmutableField) another);
  }

  private boolean equalTo(int synthetic, ImmutableField another) {
    return name.equals(another.name)
        && Objects.equals(comment, another.comment)
        && typeName.equals(another.typeName)
        && position == another.position
        && nullable == another.nullable
        && Objects.equals(typeJson, another.typeJson)
        && Objects.equals(typePrecision, another.typePrecision);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code comment}, {@code typeName}, {@code position}, {@code nullable}, {@code typeJson}, {@code typePrecision}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + typeName.hashCode();
    h += (h << 5) + position;
    h += (h << 5) + Boolean.hashCode(nullable);
    h += (h << 5) + Objects.hashCode(typeJson);
    h += (h << 5) + Objects.hashCode(typePrecision);
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Field{"
        + "name=" + name
        + ", comment=" + comment
        + ", typeName=" + typeName
        + ", position=" + position
        + ", nullable=" + nullable
        + ", typeJson=" + typeJson
        + ", typePrecision=" + typePrecision
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Field", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Field {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String comment;
    @javax.annotation.Nullable String typeName;
    int position;
    boolean positionIsSet;
    boolean nullable;
    boolean nullableIsSet;
    @javax.annotation.Nullable String typeJson;
    @javax.annotation.Nullable String typePrecision;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("comment")
    public void setComment(@Nullable String comment) {
      this.comment = comment;
    }
    @JsonProperty("type_name")
    public void setTypeName(String typeName) {
      this.typeName = typeName;
    }
    @JsonProperty("position")
    public void setPosition(int position) {
      this.position = position;
      this.positionIsSet = true;
    }
    @JsonProperty("nullable")
    public void setNullable(boolean nullable) {
      this.nullable = nullable;
      this.nullableIsSet = true;
    }
    @JsonProperty("type_json")
    public void setTypeJson(@Nullable String typeJson) {
      this.typeJson = typeJson;
    }
    @JsonProperty("type_precision")
    public void setTypePrecision(@Nullable String typePrecision) {
      this.typePrecision = typePrecision;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getComment() { throw new UnsupportedOperationException(); }
    @Override
    public String getTypeName() { throw new UnsupportedOperationException(); }
    @Override
    public int getPosition() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isNullable() { throw new UnsupportedOperationException(); }
    @Override
    public String getTypeJson() { throw new UnsupportedOperationException(); }
    @Override
    public String getTypePrecision() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableField fromJson(Json json) {
    ImmutableField.Builder builder = ImmutableField.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.typeName != null) {
      builder.typeName(json.typeName);
    }
    if (json.positionIsSet) {
      builder.position(json.position);
    }
    if (json.nullableIsSet) {
      builder.nullable(json.nullable);
    }
    if (json.typeJson != null) {
      builder.typeJson(json.typeJson);
    }
    if (json.typePrecision != null) {
      builder.typePrecision(json.typePrecision);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Field} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static ImmutableField copyOf(Field instance) {
    if (instance instanceof ImmutableField) {
      return (ImmutableField) instance;
    }
    return ImmutableField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableField ImmutableField}.
   * <pre>
   * ImmutableField.builder()
   *    .name(String) // required {@link Field#getName() name}
   *    .comment(String | null) // nullable {@link Field#getComment() comment}
   *    .typeName(String) // required {@link Field#getTypeName() typeName}
   *    .position(int) // required {@link Field#getPosition() position}
   *    .nullable(boolean) // required {@link Field#isNullable() nullable}
   *    .typeJson(String | null) // nullable {@link Field#getTypeJson() typeJson}
   *    .typePrecision(String | null) // nullable {@link Field#getTypePrecision() typePrecision}
   *    .build();
   * </pre>
   * @return A new ImmutableField builder
   */
  public static ImmutableField.Builder builder() {
    return new ImmutableField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableField ImmutableField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Field", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE_NAME = 0x2L;
    private static final long INIT_BIT_POSITION = 0x4L;
    private static final long INIT_BIT_NULLABLE = 0x8L;
    private long initBits = 0xfL;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String comment;
    private @javax.annotation.Nullable String typeName;
    private int position;
    private boolean nullable;
    private @javax.annotation.Nullable String typeJson;
    private @javax.annotation.Nullable String typePrecision;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Field} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Field instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      @Nullable String commentValue = instance.getComment();
      if (commentValue != null) {
        comment(commentValue);
      }
      this.typeName(instance.getTypeName());
      this.position(instance.getPosition());
      this.nullable(instance.isNullable());
      @Nullable String typeJsonValue = instance.getTypeJson();
      if (typeJsonValue != null) {
        typeJson(typeJsonValue);
      }
      @Nullable String typePrecisionValue = instance.getTypePrecision();
      if (typePrecisionValue != null) {
        typePrecision(typePrecisionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getComment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("comment")
    public final Builder comment(@Nullable String comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getTypeName() typeName} attribute.
     * @param typeName The value for typeName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type_name")
    public final Builder typeName(String typeName) {
      this.typeName = Objects.requireNonNull(typeName, "typeName");
      initBits &= ~INIT_BIT_TYPE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getPosition() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("position")
    public final Builder position(int position) {
      this.position = position;
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#isNullable() nullable} attribute.
     * @param nullable The value for nullable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nullable")
    public final Builder nullable(boolean nullable) {
      this.nullable = nullable;
      initBits &= ~INIT_BIT_NULLABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getTypeJson() typeJson} attribute.
     * @param typeJson The value for typeJson (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type_json")
    public final Builder typeJson(@Nullable String typeJson) {
      this.typeJson = typeJson;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getTypePrecision() typePrecision} attribute.
     * @param typePrecision The value for typePrecision (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type_precision")
    public final Builder typePrecision(@Nullable String typePrecision) {
      this.typePrecision = typePrecision;
      return this;
    }

    /**
     * Builds a new {@link ImmutableField ImmutableField}.
     * @return An immutable instance of Field
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableField(name, comment, typeName, position, nullable, typeJson, typePrecision);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE_NAME) != 0) attributes.add("typeName");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      if ((initBits & INIT_BIT_NULLABLE) != 0) attributes.add("nullable");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
