/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.zeepath;

import java.util.function.Predicate;
import zeenea.connector.commons.zeepath.InvalidZeePathException;
import zeenea.connector.commons.zeepath.ParsedRef;
import zeenea.connector.commons.zeepath.PathParser;
import zeenea.connector.source.ZeePath;

public final class ZeePathParser<T> {
    private final PathParser<T> parser;
    private final Predicate<T> filter;

    private ZeePathParser(PathParser<T> parser, Predicate<T> filter) {
        this.parser = parser;
        this.filter = filter;
    }

    public static <U> ZeePathParser<U> of(PathParser<U> parser) {
        return new ZeePathParser<Object>(parser, __ -> true);
    }

    public ZeePathParser<T> filter(Predicate<T> filter) {
        return new ZeePathParser<T>(this.parser, filter);
    }

    public ParsedRef<T> parse(ZeePath path) {
        try {
            T itemRef = this.parser.parse(path);
            if (this.filter.test(itemRef)) {
                return ParsedRef.supported(path, itemRef);
            }
            return ParsedRef.ignored(path);
        }
        catch (InvalidZeePathException e) {
            return ParsedRef.invalid(path, e);
        }
    }
}

