/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.itemidentifier;

import java.util.function.Predicate;
import zeenea.connector.common.ItemIdentifier;
import zeenea.connector.commons.itemidentifier.InvalidItemIdentifierException;
import zeenea.connector.commons.itemidentifier.ParsedRef;
import zeenea.connector.commons.itemidentifier.PathParser;

public final class ItemIdentifierParser<T> {
    private final PathParser<T> parser;
    private final Predicate<T> filter;

    private ItemIdentifierParser(PathParser<T> parser, Predicate<T> filter) {
        this.parser = parser;
        this.filter = filter;
    }

    public static <U> ItemIdentifierParser<U> of(PathParser<U> parser) {
        return new ItemIdentifierParser<Object>(parser, __ -> true);
    }

    public ItemIdentifierParser<T> filter(Predicate<T> filter) {
        return new ItemIdentifierParser<T>(this.parser, filter);
    }

    public ParsedRef<T> parse(ItemIdentifier itemIdentifier) {
        try {
            T itemRef = this.parser.parse(itemIdentifier);
            if (this.filter.test(itemRef)) {
                return ParsedRef.supported(itemIdentifier, itemRef);
            }
            return ParsedRef.ignored(itemIdentifier);
        }
        catch (InvalidItemIdentifierException e) {
            return ParsedRef.invalid(itemIdentifier, e);
        }
    }
}

